import { url } from '@/tripartite/buildBigScreen/src/config';
import crypto from '@/tripartite/buildBigScreen/src/utils/crypto'
import request from '../axios';
export const getList = (current, size, params) => {
  return request({
    url: url + 'bigScreen/bladeVisualDb/v1/query',
    method: 'post',
    params: {
      ...params,
      current,
      size,
    }
  })
}

export const getDetail = (id) => {
  return request({
    url: url + '/db/detail',
    method: 'get',
    params: {
      id
    }
  })
}

export const remove = (ids) => {
  return request({
    url: url + '/db/remove',
    method: 'post',
    params: {
      ids,
    }
  })
}

export const add = (row) => {
  return request({
    url: url + '/db/submit',
    method: 'post',
    data: row
  })
}

export const update = (row) => {
  return request({
    url: url + '/db/submit',
    method: 'post',
    data: row
  })
}
export const dynamicSql = (data) => {
  return new Promise((resolve, reject) => {
    req.get(report + `bigScreen/bladeVisualConfig/v1/dosql`, data).then(
      resp => {
        resolve(resp.data)
      },
      error => {
        reject(error)
      }
    )
  })
}
export const dbTest = (data) => {
  return request({
    url: url + '/db/db-test',
    method: 'post',
    headers: {
      'Content-Type': 'application/json'
    },
    data: crypto.encrypt(JSON.stringify(data))
  })
}