package com.artfess.workflow.conf;

import com.artfess.activemq.model.JmsTableTypeConf;
import com.artfess.activemq.model.JmsTableTypeFiledDetail;
import com.artfess.base.util.JsonUtil;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.FormExt;
import com.artfess.bpm.model.form.Form;
import com.artfess.bpm.model.process.nodedef.ext.extmodel.DefaultFormExt;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WorkflowPluginConfig {

    @Bean("formExtregister")
    public FormExt formExt() {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(FormExt.class, new FormExtEventDeserializer());
        module.addDeserializer(Form.class, new FormEventDeserializer());
        JsonUtil.getMapper().registerModule(module);
        return new DefaultFormExt();
    }

    @Bean("modelTableTypeConf")
    public JmsTableTypeConf TableTypeConf() {
        JmsTableTypeConf.AddTypeConf("FLOW_TYPE", new JmsTableTypeFiledDetail("bpm_definition", "DEF_ID_", "TYPE_ID_", "TYPE_NAME_"));
        JmsTableTypeConf.AddTypeConf("FLOW_TYPE", new JmsTableTypeFiledDetail("bpm_watermark_type", "ID_", "TYPE_ID_", "TYPE_NAME_"));
        return null;
    }

}
