package com.artfess.cqlt.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 财务大屏统计请求参数vo
 *
 * @Author : min.wu
 * @Date: 2023/03/30 17:58
 */
@Data
@ApiModel(value="财务指标大屏统计请求参数vo")
public class FaTargetRespVo {

    @ApiModelProperty(value = "英文指标")
    private String targetNameEn;

    @ApiModelProperty(value = "指标名称")
    private String targetName;

    @ApiModelProperty(value = "指标单位")
    private String targetUnit;

    @ApiModelProperty(value = "指标id")
    private String targetId;

    @ApiModelProperty(value = "指标层级")
    private String level;

    @ApiModelProperty(value = "统计纬度（1：实际值 2：预算值 3:实际累计值 4：预算累计值 5：增长率 6：完成率 " +
            "7：平均EBITDA率 8：担保总额 9：贷款余额 10：利率 11:1M 12:3M 13:6M 14 环比增减值 15 销售量 16 生产量 ）")
    private String staLat;

    @ApiModelProperty(value = "报表类型(1:当月实际VS预算分析，2:累计实际VS预算分析，3:同比分析，4:环比分析，5:年度实际VS预算分析，6:生产企业实际VS预算分析,7:非生产企业实际VS预算分析" +
            "，8：增长率分析，9：集团层面完成率分析，10：子企业完成率排名，11：占比分析，12：子企业当月实际VS集团均值排名，13：首页数值,14:年度实际VS预算分析" +
            ",15：季度累计实际分析 16:子企业累计实际情况分析,17:银行贷款余额利率分析 ,18 桥图)")
    private String type;

    @ApiModelProperty(value = "单位换算(1:万欧 2：亿欧)")
    private String conversionUnit;

    @ApiModelProperty(value = "链接主题【字典】（财务：Finance,运营：operation,投资：invest,人力：hr,资金：money）")
    private String linksType;

    @ApiModelProperty(value = "关联指标code")
    private String relatedCode;

    @ApiModelProperty(value = "数值")
    private BigDecimal showValue;

    @ApiModelProperty(value = "序号")
    private Integer sn;

    @ApiModelProperty(value = "统计图数据")
    private List<FaReportRespVo> resultData;

    @ApiModelProperty(value = "银行贷款信息")
    private List<BankLoanDetailRespVo> bankLoanList;

    @ApiModelProperty(value = "欧元同业拆借利率信息")
    private List<EuroRatesRespVo> euroRatesList;

    @ApiModelProperty(value = "是否有下级指标 0:无 1:有")
    private String lowerStatus;

    @ApiModelProperty(value = "是否数据分析 0:无 1:有")
    private String isData;

    @ApiModelProperty(value = "截止日期")
    private String asDate;

    @ApiModelProperty(value = "包含的报表类型")
    private String containType;

    @ApiModelProperty(value = "年度控制总额水平线(万欧)")
    private BigDecimal controlMoney;

    @ApiModelProperty(value = "年初担保批准额度水平线(万欧)")
    private BigDecimal earlyGuaranteeMoney;

    @ApiModelProperty(value = "总额")
    private BigDecimal totalMoney;

    @ApiModelProperty(value = "桥图分析 0:无 1:有")
    private String bridgeFigure;

    @ApiModelProperty(value = "桥图信息")
    private List<BridgeFigureVo> bridgeFigureList;

}

