package com.artfess.cqlt.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 运营--年降数据填报详情表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 黎沐华
 * @since 2023-02-21
 */
@Data
@ApiModel(value="QfOperationReductionsD对象", description="运营--年降数据填报详情表")
public class QfOperationReductionsD extends BaseModel<QfOperationReductionsD> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @Excel(name = "Product", column = "A")
    @ApiModelProperty(value = "产品")
    @TableField("customer_")
    private String customer;

    @Excel(name = "Actual", column = "C")
    @ApiModelProperty(value = "实际（百万欧元）")
    @TableField("actual_")
    private BigDecimal actual;

    @Excel(name = "Budget", column = "B")
    @ApiModelProperty(value = "预算（百万欧元）")
    @TableField("budget_")
    private BigDecimal budget;

    @Excel(name = "Actual Rate", column = "D")
    @ApiModelProperty(value = "差异（百万欧元）")
    @TableField("differences_")
    private BigDecimal differences;


    @ApiModelProperty(value = "实际占收入比例（%）")
    @TableField("actual_rate_")
    private BigDecimal actualRate;

    @ApiModelProperty(value = "预算占收入比例（%）")
    @TableField("budget_rate_")
    private BigDecimal budgetRate;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

}
