package com.artfess.cqlt.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

/**
 * 投资--萨固密集团专利授权数据主表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-23
 */
@Data
@ApiModel(value="QfInvestPatentM对象", description="投资--萨固密集团专利授权数据主表")
public class QfInvestPatentM extends AutoFillModel<QfInvestPatentM> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "报表ID")
    @TableField("report_id_")
    private String reportId;

    @ApiModelProperty(value = "填报年")
    @TableField("fill_year_")
    private Integer fillYear;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @ApiModelProperty(value = "填报人")
    @TableField("fill_user_")
    private String fillUser;

    @ApiModelProperty(value = "报表状态【字典】（0：临时，1：正式）")
    @TableField("status_")
    private Integer status;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "运营--萨固密集团专利授权详情数据")
    @TableField(exist=false)
    private List<QfInvestPatentD> list;

}
