package com.artfess.cqlt.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 人资--人员数据填报详情表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-27
 */
@Data
@ApiModel(value="QfHrPersonD对象", description="人资--人员数据填报详情表")
public class QfHrPersonD extends BaseModel<QfHrPersonD> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @Excel(name = "enterpriseCode", column = "C")
    @ApiModelProperty(value = "所属企业编码")
    @TableField("enterprise_code_")
    private String enterpriseCode;

    @Excel(name = "enterpriseName", column = "D")
    @ApiModelProperty(value = "所属企业名称")
    @TableField("enterprise_name_")
    private String enterpriseName;

    @ApiModelProperty(value = "所属企业英文名称")
    @TableField("enterprise_name_en_")
    private String enterpriseNameEn;

    @Excel(name = "subjectCode", column = "A")
    @ApiModelProperty(value = "科目编码")
    @TableField("subject_code_")
    private String subjectCode;

    @ApiModelProperty(value = "科目层级")
    @TableField("subject_level_")
    private Integer subjectLevel;

    @Excel(name = "subjectName", column = "B")
    @ApiModelProperty(value = "科目中文名称")
    @TableField("subject_name_")
    private String subjectName;

    @ApiModelProperty(value = "科目英文名称")
    @TableField("subject_name_en_")
    private String subjectNameEn;

    @ApiModelProperty(value = "科目计量单位（由科目关联）")
    @TableField("subject_unit_")
    private String subjectUnit;

    @ApiModelProperty(value = "填报数量")
    @TableField(exist = false)
    private BigDecimal fillData;

    @Excel(name = "fillData", column = "E")
    @ApiModelProperty(value = "当月实际数据")
    @TableField("actual_")
    private BigDecimal actual;

    @Excel(name = "fillData", column = "E")
    @ApiModelProperty(value = "当年累计实际数")
    @TableField("actual_ytd_")
    private BigDecimal actualYtd;

    @ApiModelProperty(value = "排序号")
    @TableField("sn_")
    protected Integer sn;

    @ApiModelProperty(value = "所在列")
    @TableField("column_")
    protected Integer column;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

}
