package com.artfess.cqlt.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 财务-国资委资产负债和利润汇总表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
@Data
@ApiModel(value="QfFinanceReportingSummaryS对象", description="财务-国资委资产负债和利润汇总表")
public class QfFinanceReportingSummaryS extends BaseModel<QfFinanceReportingSummaryS> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "填报年")
    @TableField("fill_year_")
    private Integer fillYear;

    @ApiModelProperty(value = "填报季度")
    @TableField("fill_quarter_")
    private Integer fillQuarter;

    @ApiModelProperty(value = "填报月")
    @TableField("fill_month_")
    private Integer fillMonth;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @ApiModelProperty(value = "科目编码")
    @TableField("subject_code_")
    private String subjectCode;

    @ApiModelProperty(value = "科目英文名称")
    @TableField("subject_name_en_")
    private String subjectNameEn;

    @ApiModelProperty(value = "科目计量单位位（由科目关联）")
    @TableField("subject_unit_")
    private String subjectUnit;

    @ApiModelProperty(value = "当月实际数据汇总值")
    @TableField("actual_total_")
    private BigDecimal actualTotal;

    @ApiModelProperty(value = "当月实际数据抵扣值")
    @TableField("actual_posting_")
    private BigDecimal actualPosting;

    @ApiModelProperty(value = "当月实际数据合并值")
    @TableField("actual_consolidated_")
    private BigDecimal actualConsolidated;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime;

}
