package com.artfess.cqlt.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationSalesDDao;
import com.artfess.cqlt.dao.QfOperationSalesMDao;
import com.artfess.cqlt.manager.QfOperationSalesDManager;
import com.artfess.cqlt.model.QfOperationReductionsM;
import com.artfess.cqlt.model.QfOperationSalesD;
import com.artfess.cqlt.model.QfOperationSalesM;
import com.artfess.i18n.util.I18nUtil;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;

/**
 * 运营--企业销售数据填报详情表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-17
 */
@Service
public class QfOperationSalesDManagerImpl extends BaseManagerImpl<QfOperationSalesDDao, QfOperationSalesD> implements QfOperationSalesDManager {

    @Resource
    private QfOperationSalesMDao salesMDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean batchSave(QfOperationSalesM t) {
        Assert.hasText(t.getId(), I18nUtil.getMessage("QfOperationKpiM.reportId", LocaleContextHolder.getLocale()));
        t.getList().forEach(detail -> {
            detail.setMainId(t.getId());
        });
        boolean b = this.saveOrUpdateBatch(t.getList());
        return b;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean batchUpdate(QfOperationSalesM t) {
        Assert.hasText(t.getId(), I18nUtil.getMessage("QfOperationKpiM.reportId", LocaleContextHolder.getLocale()));
        QfOperationSalesM salesM = salesMDao.selectById(t.getId());
        Assert.notNull(salesM, I18nUtil.getMessage("filldata.notExist", LocaleContextHolder.getLocale()));
        Assert.isTrue(!"1".equals(salesM.getStatus()),  I18nUtil.getMessage("data_operate", LocaleContextHolder.getLocale()));
        t.getList().forEach(detail -> {
            detail.setMainId(t.getId());
        });
        boolean b = this.saveOrUpdateBatch(t.getList());
        return b;
    }
}
