package com.artfess.cqlt.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationNewOrdersMDao;
import com.artfess.cqlt.manager.QfOperationNewOrdersDManager;
import com.artfess.cqlt.manager.QfOperationNewOrdersMManager;
import com.artfess.cqlt.model.QfOperationMacrM;
import com.artfess.cqlt.model.QfOperationNewOrdersD;
import com.artfess.cqlt.model.QfOperationNewOrdersM;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 运营--新订单数据填报主表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-21
 */
@Service
public class QfOperationNewOrdersMManagerImpl extends BaseManagerImpl<QfOperationNewOrdersMDao, QfOperationNewOrdersM> implements QfOperationNewOrdersMManager {

    @Autowired
    private QfOperationNewOrdersDManager operationSalesDManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean insertInfo(QfOperationNewOrdersM t) {
        QueryWrapper<QfOperationNewOrdersM> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getFillYear());
        queryWrapper.eq("fill_month_", t.getFillMonth());
        queryWrapper.eq("report_id_", t.getReportId());
        List<QfOperationNewOrdersM> QfOperationNewOrdersMS = this.baseMapper.selectList(queryWrapper);
        if (!CollectionUtils.isEmpty(QfOperationNewOrdersMS)) {
            throw new BaseException(I18nUtil.getMessage("QfOperationKpiM.repeat", LocaleContextHolder.getLocale()));
        }
        int insert = this.baseMapper.insert(t);
        if (insert > 0) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(QfOperationNewOrdersM t) {
        QueryWrapper<QfOperationNewOrdersM> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getFillYear());
        queryWrapper.eq("fill_month_", t.getFillMonth());
        queryWrapper.eq("report_id_", t.getReportId());
        queryWrapper.ne("id_", t.getId());
        List<QfOperationNewOrdersM> QfOperationNewOrdersMS = this.baseMapper.selectList(queryWrapper);
        if (!CollectionUtils.isEmpty(QfOperationNewOrdersMS)) {
            throw new BaseException(I18nUtil.getMessage("QfOperationKpiM.repeat", LocaleContextHolder.getLocale()));
        }
        int insert = this.baseMapper.updateById(t);
        if (insert > 0) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateStatus(QfOperationNewOrdersM t) {
        QfOperationNewOrdersM QfOperationNewOrdersM = baseMapper.selectById(t.getId());
        if (null == QfOperationNewOrdersM) {
            return false;
        }
        QfOperationNewOrdersM.setStatus(QfOperationNewOrdersM.getStatus() == 0 ? 1 : 0);
        int i = this.baseMapper.updateById(QfOperationNewOrdersM);
        if (i > 0) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean importExcel(List<QfOperationNewOrdersD> list, String mainId) {
        QfOperationNewOrdersM QfOperationNewOrdersM = this.baseMapper.selectById(mainId);
        Assert.notNull(QfOperationNewOrdersM, I18nUtil.getMessage("filldata.notExist", LocaleContextHolder.getLocale()));
        Assert.isTrue(!"1".equals(QfOperationNewOrdersM.getStatus()),  I18nUtil.getMessage("data_operate", LocaleContextHolder.getLocale()));
        QueryWrapper<QfOperationNewOrdersD> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("main_id_", mainId);
        operationSalesDManager.remove(queryWrapper);
        list.forEach(detail -> {
            detail.setMainId(mainId);
            detail.setFillDate(QfOperationNewOrdersM.getFillDate());
        });
        boolean b = operationSalesDManager.saveBatch(list);
        return b;
    }
}
