package com.artfess.cqlt.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationKpiDDao;
import com.artfess.cqlt.dao.QfOperationKpiMDao;
import com.artfess.cqlt.manager.QfOperationKpiDManager;
import com.artfess.cqlt.model.QfOperationCompanyCipM;
import com.artfess.cqlt.model.QfOperationKpiD;
import com.artfess.cqlt.model.QfOperationKpiM;
import com.artfess.i18n.util.I18nUtil;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;

/**
 * 运营--KPI数据填报详情表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-14
 */
@Service
public class QfOperationKpiDManagerImpl extends BaseManagerImpl<QfOperationKpiDDao, QfOperationKpiD> implements QfOperationKpiDManager {

    @Resource
    private QfOperationKpiMDao kpiMDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean batchSave(QfOperationKpiM t) {
        Assert.hasText(t.getId(), I18nUtil.getMessage("QfOperationKpiM.reportId", LocaleContextHolder.getLocale()));
        t.getList().forEach(detail -> {
            detail.setMainId(t.getId());
        });
        boolean b = this.saveOrUpdateBatch(t.getList());
        return b;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean batchUpdate(QfOperationKpiM t) {
        Assert.hasText(t.getId(), I18nUtil.getMessage("QfOperationKpiM.reportId", LocaleContextHolder.getLocale()));
        QfOperationKpiM qfOperationKpiM = kpiMDao.selectById(t.getId());
        Assert.notNull(qfOperationKpiM, I18nUtil.getMessage("filldata.notExist", LocaleContextHolder.getLocale()));
        Assert.isTrue(!"1".equals(qfOperationKpiM.getStatus()),  I18nUtil.getMessage("data_operate", LocaleContextHolder.getLocale()));
        t.getList().forEach(detail -> {
            detail.setMainId(t.getId());
        });
        boolean b = this.saveOrUpdateBatch(t.getList());
        return b;
    }
}
