package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationCompanyCipMDao;
import com.artfess.cqlt.dao.QfOperationCompanyCipMDao;
import com.artfess.cqlt.dao.QfSubjectInternationalInfoDao;
import com.artfess.cqlt.manager.QfEnterpriseInfoManager;
import com.artfess.cqlt.manager.QfOperationCompanyCipDManager;
import com.artfess.cqlt.manager.QfOperationCompanyCipMManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfOperationCompanyCipD;
import com.artfess.cqlt.model.QfOperationCompanyCipM;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 运营--持续改进数据-分公司填报主表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-21
 */
@Service
public class QfOperationCompanyCipMManagerImpl extends BaseManagerImpl<QfOperationCompanyCipMDao, QfOperationCompanyCipM> implements QfOperationCompanyCipMManager {


    @Autowired
    private QfOperationCompanyCipDManager operationCipDManager;

    @Autowired
    private QfEnterpriseInfoManager enterpriseInfoManager;


    private void processDetail(List<QfOperationCompanyCipD> list, String id) {
        QueryWrapper<QfOperationCompanyCipD> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("main_id_", id);
        operationCipDManager.remove(queryWrapper);
        list.forEach(detail -> {
            detail.setMainId(id);
        });
        operationCipDManager.saveBatch(list);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean importExcel(List<QfOperationCompanyCipD> list, String mainId) {
        QfOperationCompanyCipM cipM = this.baseMapper.selectById(mainId);
        Assert.notNull(cipM, I18nUtil.getMessage("filldata.notExist", LocaleContextHolder.getLocale()));
        Assert.isTrue(!"1".equals(cipM.getStatus()),  I18nUtil.getMessage("data_operate", LocaleContextHolder.getLocale()));
        //获取所有国际科目 然后去对比code 没有的给出提示
        QueryWrapper<QfSubjectInternationalInfo> query = new QueryWrapper<>();
        query.eq("IS_DELE_", DelStatusEnum.N.getType());
        //获取境外企业
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = enterpriseInfoManager.getEnterpriseInfoMap(null);
        StringBuffer sb = new StringBuffer();
        QueryWrapper<QfOperationCompanyCipD> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("main_id_", mainId);
        operationCipDManager.remove(queryWrapper);
        list.forEach(detail -> {
            detail.setMainId(mainId);
            detail.setFillDate(cipM.getFillDate());
            if(StringUtils.isEmpty(detail.getEnterpriseCode())) {
                throw new BaseException(I18nUtil.getMessage("fill.code", LocaleContextHolder.getLocale()));
            }
            if(!enterpriseInfoMap.containsKey(detail.getEnterpriseCode())) {
                sb.append(",");
                sb.append(detail.getEnterpriseCode());
            }else {
                QfEnterpriseInfo qfEnterpriseInfo = enterpriseInfoMap.get(detail.getEnterpriseCode());
                detail.setEnterpriseName(qfEnterpriseInfo.getName());
                detail.setEnterpriseType(qfEnterpriseInfo.getEconomyType());
                detail.setEnterpriseArea(qfEnterpriseInfo.getContinent());
            }

        });
//        if(sb.length() > 0) {
//            throw new BaseException(sb.substring(1) + I18nUtil.getMessage("code.notExist", LocaleContextHolder.getLocale()));
//        }
        boolean b = operationCipDManager.saveBatch(list);
        return b;
    }

    @Override
    public boolean updateStatus(QfOperationCompanyCipM t) {
        QfOperationCompanyCipM cipM = baseMapper.selectById(t.getId());
        if(null == cipM) {
            return false;
        }
        cipM.setStatus(cipM.getStatus() == 0? 1:0 );
        int i = this.baseMapper.updateById(cipM);
        if(i > 0){
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean insertInfo(QfOperationCompanyCipM t) {
        QueryWrapper<QfOperationCompanyCipM> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getFillYear());
        queryWrapper.eq("fill_month_", t.getFillMonth());
        queryWrapper.eq("report_id_", t.getReportId());
        List<QfOperationCompanyCipM> operationCipMS = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(operationCipMS)) {
            throw new BaseException(I18nUtil.getMessage("QfOperationKpiM.repeat", LocaleContextHolder.getLocale()));
        }
        int insert = this.baseMapper.insert(t);
        if(insert > 0){
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(QfOperationCompanyCipM t) {
        QueryWrapper<QfOperationCompanyCipM> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getFillYear());
        queryWrapper.eq("fill_month_", t.getFillMonth());
        queryWrapper.eq("report_id_", t.getReportId());
        queryWrapper.ne("id_", t.getId());
        List<QfOperationCompanyCipM> operationCipMS = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(operationCipMS)) {
            throw new BaseException(I18nUtil.getMessage("QfOperationKpiM.repeat", LocaleContextHolder.getLocale()));
        }
        int insert = this.baseMapper.updateById(t);
        if(insert > 0){
            return true;
        }
        return false;
    }

}
