package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.KpiTargetTypeEnum;
import com.artfess.base.enums.ProductSalesDataTypeEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.cqlt.dao.QfOperatingStatisticalDao;
import com.artfess.cqlt.dao.QfOperationSalesProductMDao;
import com.artfess.cqlt.dao.SysSubjectTargetDao;
import com.artfess.cqlt.manager.QfOperatingStatisticalManager;
import com.artfess.cqlt.manager.QfOperationCipDManager;
import com.artfess.cqlt.manager.QfOperationCompanyCipDManager;
import com.artfess.cqlt.manager.QfOperationNewOrdersDManager;
import com.artfess.cqlt.manager.QfOperationReductionsDManager;
import com.artfess.cqlt.manager.QfOperationSalesProductDManager;
import com.artfess.cqlt.manager.QfOperationSalesProductMManager;
import com.artfess.cqlt.manager.QfOperationSopDManager;
import com.artfess.cqlt.model.QfOperatingStatistical;
import com.artfess.cqlt.model.SysSubjectTarget;
import com.artfess.cqlt.vo.FaTargetRespVo;
import com.artfess.cqlt.vo.OpReportRespVo;
import com.artfess.cqlt.vo.OpTargetRespVo;
import com.artfess.cqlt.vo.OpReportReqVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;

/**
 * 运营-大屏统计宽表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-30
 */
@Service
public class QfOperatingStatisticalManagerImpl extends BaseManagerImpl<QfOperatingStatisticalDao, QfOperatingStatistical> implements QfOperatingStatisticalManager {

    @Resource
    private QfOperationSalesProductMDao salesProductMDao;

    @Autowired
    private QfOperationSopDManager sopDManager;

    @Autowired
    private QfOperationReductionsDManager reductionsDManager;

    @Autowired
    private QfOperationNewOrdersDManager ordersDManager;

    @Autowired
    private QfOperationCompanyCipDManager companyCipDManager;

    @Autowired
    private QfOperationCipDManager cipDManager;

    @Resource
    private SysSubjectTargetDao subjectTargetDao;

    @Resource
    private QfOperationSalesProductMManager salesProductMManager;

    @Override
    public List<OpTargetRespVo> data(OpReportReqVo t) {
        //获取当前指标的年季月趋势数据
        if (null == t.getYear() || t.getYear() <= 0) {
            int year = LocalDate.now().getYear();
            t.setYear(year);
        }

        if (null == t.getStartYear() || null == t.getEndYear()) {
            t.setEndYear(t.getYear());
            t.setStartYear(t.getYear() - 5);
        }
        t.setYear(null);

        QueryWrapper<SysSubjectTarget> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("business_", "operation");
        queryWrapper.eq("target_level_", 1);
        List<SysSubjectTarget> targetList = this.subjectTargetDao.selectList(queryWrapper);
        List<OpTargetRespVo> resultList = Lists.newArrayList();
        targetList.forEach(target -> {
            String type =null;
            if(!StringUtil.isEmpty(target.getType())){
                type = target.getType().split(",")[0];
            }
            t.setTargetId(target.getId());
            OpTargetRespVo resultFa = new OpTargetRespVo();
            resultFa.setTargetId(target.getId());
            resultFa.setTargetName(target.getName());
            resultFa.setTargetNameEn(target.getTargetNameEn());
            resultFa.setTargetUnit(target.getUnit());
            resultFa.setType(type);
            resultFa.setStaLat(target.getStaLat().trim());
            resultFa.setSn(target.getSn());
            resultFa.setContainType(target.getType());
            switch (target.getCode()) {
                case "OP001":
                    t.setDataType(Integer.parseInt(ProductSalesDataTypeEnum.ONE.getType()));
                    List<OpReportRespVo> reportRespVos = salesProductMDao.yearData(t);
                    resultFa.setResultData(reportRespVos);
                    break;
                case "OP002":
                    reportRespVos = sopDManager.yearData(t);
                    resultFa.setResultData(reportRespVos);
                    break;
                case "OP003":
                    reportRespVos = reductionsDManager.yearData(t);
                    resultFa.setResultData(reportRespVos);
                    break;
                case "OP004":
                    reportRespVos = ordersDManager.yearData(t);
                    resultFa.setResultData(reportRespVos);
                    break;
                case "OP005":
                    reportRespVos = cipDManager.yearData(t);
                    resultFa.setResultData(reportRespVos);
                    break;
                case "OP006":
                    reportRespVos = companyCipDManager.yearData(t);
                    resultFa.setResultData(reportRespVos);
                    break;
                default:
                    break;
            }
            resultFa.getResultData().forEach(reportRespVo->{
                if (StringUtils.isEmpty(target.getStaLat())) {
                    return;
                }
                if (target.getStaLat().length() < 2) {
                    return;
                }
                if (null != reportRespVo.getBudget() && null != reportRespVo.getActual()) {
                    BigDecimal differenceValue = reportRespVo.getActual().subtract(reportRespVo.getBudget());
                    reportRespVo.setDifferenceValue(differenceValue);
                    String differenceRate = null;
                    if(0 != reportRespVo.getActual().doubleValue()) {
                        differenceRate = differenceValue.divide(reportRespVo.getActual(), 2, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal("100")) + "%";
                    }
                    reportRespVo.setDifferenceRate(differenceRate);
                }
            });
            resultList.add(resultFa);
        });

        return resultList;
    }

    @Override
    public List<OpTargetRespVo> fromUnderData(OpReportReqVo t) {
        Assert.hasText(t.getTargetId(), "请选择要统计的指标id");
        SysSubjectTarget target = subjectTargetDao.selectById(t.getTargetId());
        Assert.notNull(target, "当前指标不存在");
        if (StringUtils.isEmpty(target.getType())) {
            return Lists.newArrayList();
        }
        List<OpTargetRespVo> list = Lists.newArrayList();
        switch (target.getCode()) {
            case "OP001":
                list = salesProductMManager.dataAnalysis(t, target);
                break;
            case "OP002":
                list = sopDManager.dataAnalysis(t, target);
                break;
            case "OP003":
                list = reductionsDManager.dataAnalysis(t, target);
                break;
            case "OP004":
                list = ordersDManager.dataAnalysis(t, target);
                break;
            case "OP005":
                list = cipDManager.dataAnalysis(t, target);
                break;
            case "OP006":
                list = companyCipDManager.dataAnalysis(t, target);
                break;
            default:
                break;
        }
        list.forEach(resp -> {
            resp.getResultData().forEach(reportRespVo->{
                if (StringUtils.isEmpty(target.getStaLat())) {
                    return;
                }
                if (target.getStaLat().length() < 2) {
                    return;
                }
                if (null != reportRespVo.getBudget() && null != reportRespVo.getActual()) {
                    BigDecimal differenceValue = reportRespVo.getActual().subtract(reportRespVo.getBudget());
                    reportRespVo.setDifferenceValue(differenceValue);
                    String differenceRate = null;
                    if(0 != reportRespVo.getBudget().doubleValue()) {
                        differenceRate = differenceValue.divide(reportRespVo.getBudget(), 2, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal("100")) + "%";
                    }
                    reportRespVo.setDifferenceRate(differenceRate);
                }
            });
        });

        return list;
    }

}
