package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfInvestPatentMDao;
import com.artfess.cqlt.dao.QfSubjectInternationalInfoDao;
import com.artfess.cqlt.manager.QfInvestPatentDManager;
import com.artfess.cqlt.manager.QfInvestPatentMManager;
import com.artfess.cqlt.model.QfInvestPatentD;
import com.artfess.cqlt.model.QfInvestPatentM;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 投资--萨固密集团专利授权数据主表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-23
 */
@Service
public class QfInvestPatentMManagerImpl extends BaseManagerImpl<QfInvestPatentMDao, QfInvestPatentM> implements QfInvestPatentMManager {

    @Autowired
    private QfInvestPatentDManager investPatentDManager;

    @Resource
    private QfSubjectInternationalInfoDao subjectInternationalInfoDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean importExcel(List<QfInvestPatentD> list, String mainId) {
        QfInvestPatentM investParent = this.baseMapper.selectById(mainId);
        Assert.notNull(investParent, I18nUtil.getMessage("filldata.notExist", LocaleContextHolder.getLocale()));
        Assert.isTrue(!"1".equals(investParent.getStatus()),  I18nUtil.getMessage("data_operate", LocaleContextHolder.getLocale()));
        //获取所有国际科目 然后去对比code 没有的给出提示
        QueryWrapper<QfSubjectInternationalInfo> query = new QueryWrapper<>();
        query.eq("IS_DELE_", DelStatusEnum.N.getType());
        List<QfSubjectInternationalInfo> qfSubjectInternationalInfos = subjectInternationalInfoDao.selectList(query);
        Map<String, QfSubjectInternationalInfo> detailMap = qfSubjectInternationalInfos.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        StringBuffer sb = new StringBuffer();
        QueryWrapper<QfInvestPatentD> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("main_id_", mainId);
        investPatentDManager.remove(queryWrapper);
        list.forEach(detail -> {
            detail.setMainId(mainId);
            detail.setFillDate(investParent.getFillDate());
            if(StringUtils.isEmpty(detail.getSubjectCode())) {
                throw new BaseException(I18nUtil.getMessage("fill.code", LocaleContextHolder.getLocale()));
            }
            if(!detailMap.containsKey(detail.getSubjectCode())) {
                sb.append(",");
                sb.append(detail.getSubjectCode());
            }else {
                QfSubjectInternationalInfo subjectInternationalInfo = detailMap.get(detail.getSubjectCode());
                detail.setSubjectNameEn(subjectInternationalInfo.getNameEn());
                detail.setSubjectUnit(subjectInternationalInfo.getUnit());
                detail.setSubjectName(subjectInternationalInfo.getName());
                if(!StringUtils.isEmpty(subjectInternationalInfo.getLevel())) {
                    detail.setSubjectLevel(Integer.parseInt(subjectInternationalInfo.getLevel()));
                }
            }

        });
        if(sb.length() > 0) {
            throw new BaseException(sb.substring(1) + I18nUtil.getMessage("code.notExist", LocaleContextHolder.getLocale()));
        }
        boolean b = investPatentDManager.saveBatch(list);
        return b;
    }

    @Override
    public boolean updateStatus(QfInvestPatentM t) {
        QfInvestPatentM cipM = baseMapper.selectById(t.getId());
        if(null == cipM) {
            return false;
        }
        cipM.setStatus(cipM.getStatus() == 0? 1:0 );
        int i = this.baseMapper.updateById(cipM);
        if(i > 0){
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean insertInfo(QfInvestPatentM t) {
        QueryWrapper<QfInvestPatentM> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getFillYear());
        queryWrapper.eq("report_id_", t.getReportId());
        List<QfInvestPatentM> operationCipMS = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(operationCipMS)) {
            throw new BaseException(I18nUtil.getMessage("QfOperationKpiM.repeat", LocaleContextHolder.getLocale()));
        }
        int insert = this.baseMapper.insert(t);
        if(insert > 0){
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(QfInvestPatentM t) {
        QueryWrapper<QfInvestPatentM> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getFillYear());
        queryWrapper.eq("report_id_", t.getReportId());
        queryWrapper.ne("id_", t.getId());
        List<QfInvestPatentM> operationCipMS = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(operationCipMS)) {
            throw new BaseException(I18nUtil.getMessage("QfOperationKpiM.repeat", LocaleContextHolder.getLocale()));
        }
        int insert = this.baseMapper.updateById(t);
        if(insert > 0){
            return true;
        }
        return false;
    }
}
