package com.artfess.cqlt.manager;

import com.artfess.cqlt.model.QfFinanceLoanD;
import com.artfess.base.manager.BaseManager;
import com.artfess.cqlt.model.QfFinanceLoanM;
import com.artfess.cqlt.vo.BankLoanDetailRespVo;
import com.artfess.cqlt.vo.FaReportRespVo;
import com.artfess.cqlt.vo.MoneyReportRespVo;
import com.artfess.cqlt.vo.ReportReqVo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;

/**
 * 资金--贷款填报数据详情 服务类
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-03-02
 */
public interface QfFinanceLoanDManager extends BaseManager<QfFinanceLoanD> {

    boolean batchUpdate(QfFinanceLoanM t);

    List<MoneyReportRespVo> cqltSgYearData(ReportReqVo t);

    List<MoneyReportRespVo> cqltSgQuarterData(ReportReqVo t);

    List<MoneyReportRespVo> sgYearData(ReportReqVo t);

    List<MoneyReportRespVo> sgQuarterData(ReportReqVo t);

    List<FaReportRespVo> nbwdYearAnalysis(ReportReqVo t);

    List<FaReportRespVo> zzrzYearAnalysis(ReportReqVo t);

    List<FaReportRespVo> dbzeQuarterCompanyAnalysis(ReportReqVo t);

    List<FaReportRespVo> dkyeQuarterCompanyAnalysis(ReportReqVo t, String dataType);

    List<BankLoanDetailRespVo> bankDetail(ReportReqVo t, String dataType);

    BigDecimal getEarlyGuaranteeMoney(Integer year);

    List<FaReportRespVo> bankAnnualFigure(ReportReqVo t, String dataType);
}
