package com.artfess.cqlt.dao;

import com.artfess.cqlt.model.QfFinancialStatistical;
import com.artfess.cqlt.model.SysSubjectTarget;
import com.artfess.cqlt.vo.FaReportRespVo;
import com.artfess.cqlt.vo.FaTargetRespVo;
import com.artfess.cqlt.vo.ReportReqVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 财务主题大屏统计宽表 Mapper 接口
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-03-30
 */
public interface QfFinancialStatisticalDao extends BaseMapper<QfFinancialStatistical> {

    /**
     * 根据参数获取集团财务统计数据
     *
     * @param t
     * @return
     */
    List<SysSubjectTarget> getGroupData(@Param("vo") ReportReqVo t);

    List<FaReportRespVo> enterpriseData(@Param("vo") ReportReqVo t);

    List<FaReportRespVo> yearData(@Param("vo") ReportReqVo t);

    List<FaReportRespVo> quarterData(@Param("vo") ReportReqVo t);

    List<FaReportRespVo> monthData(@Param("vo") ReportReqVo t);

    List<FaReportRespVo> monthYtdData(@Param("vo") ReportReqVo t);

    List<FaReportRespVo> comparedAnalysis(@Param("vo") ReportReqVo t);

    List<FaReportRespVo> sequentialAnalysis(@Param("vo") ReportReqVo t);

    List<FaReportRespVo> yearAnalysis(@Param("vo") ReportReqVo t);

    List<FaReportRespVo> enterpriseAnalysis(@Param("vo") ReportReqVo t);

    List<FaReportRespVo> growthRateAnalysis(@Param("vo") ReportReqVo t);

    List<FaReportRespVo> enterpriseCompletion(@Param("vo") ReportReqVo t);

    List<FaReportRespVo> groupCompletion(@Param("vo") ReportReqVo t);

    List<FaReportRespVo> targetData(@Param("vo") ReportReqVo t, @Param("targetIds") List<String> targetIds);

    List<FaReportRespVo> meanRankAnalysis(@Param("vo") ReportReqVo t);

    List<FaReportRespVo> targetAllData(@Param("vo") ReportReqVo t);

    BigDecimal findByTargetCodeAndCompanyCode(@Param("lastYear") int lastYear, @Param("targetCode") String targetCode, @Param("enterpriseCode") String enterpriseCode);

    List<FaReportRespVo>  bridgeFigureAnalysis(@Param("vo") ReportReqVo t, @Param("targetCodes") List<String> targetCodes);

    List<FaReportRespVo> ytdBridgeFigureAnalysis(@Param("vo") ReportReqVo t, @Param("targetCodes") List<String> targetCodes);
}
