package com.artfess.cqlt.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.cqlt.manager.QfEnterpriseUsersInfoManager;
import com.artfess.cqlt.model.QfEnterpriseUsersInfo;
import com.artfess.i18n.util.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;

/**
 * 境外企业人员信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author lxk
 * @since 2023-02-10
 */
@RestController
@Api(tags = "境外企业人员信息 ")
@RequestMapping("/qfEnterpriseUsersInfo/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class QfEnterpriseUsersInfoController extends BaseController<QfEnterpriseUsersInfoManager, QfEnterpriseUsersInfo> {


    @PostMapping("/insertInfo")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> insertInfo(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({AddGroup.class}) QfEnterpriseUsersInfo t) {
        if(!baseService.save(t)) {
            return new CommonResult<String>(false, I18nUtil.getMessage("option.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }


    @PostMapping("/updateInfoById")
    @ApiOperation("更新实体")
    public CommonResult<String> updateInfoById(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({UpdateGroup.class}) QfEnterpriseUsersInfo t) {
        if(!baseService.updateById(t)) {
            return new CommonResult<String>(false, I18nUtil.getMessage("update.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }


    @GetMapping("deleteById/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        if(!baseService.removeById(id)) {
            return new CommonResult<String>(false, I18nUtil.getMessage("delete.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @PostMapping("/getList")
    @ApiOperation("企业分页查询")
    public CommonResult<PageList<QfEnterpriseUsersInfo>> getList(@RequestBody QueryFilter<QfEnterpriseUsersInfo> queryFilter) {
        return new CommonResult<PageList<QfEnterpriseUsersInfo>>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), super.query(queryFilter));
    }

    @RequestMapping(value = "updateSequence", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量修改排序号", notes = "批量修改排序号")
    public CommonResult<String> updateSequence(@ApiParam(name = "params", value = "排序参数：Key：ID，Value：排序号") @RequestBody HashMap<String, Integer> params) throws Exception {
        if(!params.isEmpty()){
            baseService.updateSequence(params);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }


}

