/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.enums;

import com.artfess.base.util.StringUtil;
import java.util.Arrays;
import java.util.List;

public enum KpiTargetTypeEnum {
    hr_acr_act_quantity_(1, "hrAcrActQuantity", "\u4e8b\u6545\u4ef6\u6570", "Act", "\u4ef6", ""),
    tr_exfi_act_(2, "trExfiAct", "\u8f6c\u6362\u7387", "TR", "%", ""),
    oee24_ex_epdm_act_(3, "oee24ExEpdmAct", "\u8bbe\u5907\u5229\u7528\u7387", "OEE", "%", ""),
    crj_exfi_act_(4, "crjExfiAct", "\u5ba2\u6237\u62d2\u6536", "PPM", "\u4ef6", ""),
    cc_exfi_act_(5, "ccExfiAct", "\u5ba2\u6237\u62b1\u6028", "CC-CPM", "\u6b21", ""),
    qr_ex_epdm_act_(6, "qr_ex_epdm_act_", "\u975e\u8ba1\u5212\u505c\u673a\u7387", "Unplanned outage rate", "%", ""),
    hr_et_rate_bud_(7, "hrEtRateBud", "\u5458\u5de5\u6548\u7387", "Employee productivity", "%", ""),
    oem_sale_(10, "oemSale", "OEM\u9500\u552e\u6570\u636e\u5bf9\u6bd4", "oem sale", "\u5343\u6b27", "3,4"),
    new_project_income_(11, "newProjectIncome", "\u65b0\u9879\u76ee\u6536\u5165\u8d21\u732e\u6570\u636e\u5bf9\u6bd4", "new project income", "\u5343\u6b27", "3,4"),
    reduction_data_(12, "reductionData", "\u5e74\u964d\u6570\u636e\u5bf9\u6bd4", "reduction data", "\u767e\u4e07\u6b27", "3,4"),
    new_order_data_(13, "newOrderData", "\u65b0\u8ba2\u5355\u6570\u636e", "new order data", "\u767e\u4e07\u6b27", "3"),
    cip(14, "cip", "\u6301\u7eed\u6539\u8fdb\u6570\u636e\u5bf9\u6bd4", "cip", "\u5343\u6b27", "3,4"),
    company_cip(15, "companyCip", "\u6301\u7eed\u6539\u8fdb\u6570\u636e\u5bf9\u6bd4-\u5206\u516c\u53f8", "company cip", "\u5343\u6b27", "3,4");

    private String targetName;
    private String targetNameEn;
    private String targetUnit;
    private String targetId;
    private Integer type;
    private String staLat;

    private KpiTargetTypeEnum(Integer type, String targetId, String targetName, String targetNameEn, String targetUnit, String staLat) {
        this.type = type;
        this.targetId = targetId;
        this.targetName = targetName;
        this.targetNameEn = targetNameEn;
        this.targetUnit = targetUnit;
        this.staLat = staLat;
    }

    public static KpiTargetTypeEnum getTarget(Integer type) {
        KpiTargetTypeEnum[] values;
        if (null == type) {
            return null;
        }
        for (KpiTargetTypeEnum state : values = KpiTargetTypeEnum.values()) {
            if (!state.getType().equals(type)) continue;
            return state;
        }
        return null;
    }

    public static KpiTargetTypeEnum findByTargetId(String targetId) {
        KpiTargetTypeEnum[] values;
        if (!StringUtil.isNotEmpty(targetId)) {
            return null;
        }
        for (KpiTargetTypeEnum state : values = KpiTargetTypeEnum.values()) {
            if (!state.getTargetId().equals(targetId)) continue;
            return state;
        }
        return null;
    }

    public static List<KpiTargetTypeEnum> salesTargetList() {
        List<KpiTargetTypeEnum> targets = Arrays.asList(oem_sale_, new_project_income_, reduction_data_, cip, new_order_data_, company_cip);
        return targets;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getTargetNameEn() {
        return this.targetNameEn;
    }

    public String getTargetUnit() {
        return this.targetUnit;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public Integer getType() {
        return this.type;
    }

    public String getStaLat() {
        return this.staLat;
    }
}

