package com.artfess.manage.safty.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * 安全目标考核评分(CmgtSaftyCheck)表实体类
 *
 * @author 黎沐华
 * @since 2023-05-05 09:23:15
 */
@Data
@TableName("CMGT_SAFTY_CHECK")
@ApiModel("全目标考核评分(CmgtSaftyCheck)表实体类")
public class CmgtSaftyCheck extends AutoFillModel<CmgtSaftyCheck> {

    @NotNull(message = "修改必须指定id", groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id", groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty("所属年度")
    @TableField("check_year_")
    private String checkYear;

    @ApiModelProperty("所属目标ID")
    @TableField("target_id_")
    private String targetId;

    @ApiModelProperty("考评人")
    @TableField("assessor_")
    private String assessor;

    @ApiModelProperty("考评时间")
    @TableField("assessor_date_")
    private LocalDate assessorDate;

    @ApiModelProperty("考评结果描述")
    @TableField("assessor_content_")
    private String assessorContent;

    @ApiModelProperty("目标考核综合得分")
    @TableField("check_score_")
    private BigDecimal checkScore = new BigDecimal(0);

    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    @TableField("is_dele_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("last_time_")
    private LocalDateTime lastTime;

    @ApiModelProperty("考核项详细数据")
    @TableField(exist = false)
    private List<CmgtSaftyCheckItem> detail = new ArrayList<>();

}

