package com.artfess.manage.safty.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.safty.dao.CmgtSaftyAppraisalDao;
import com.artfess.manage.safty.manager.CmgtSaftyAppraisalManager;
import com.artfess.manage.safty.manager.dto.CmgtSaftyAppraisalDto;
import com.artfess.manage.safty.manager.mapper.CmgtSaftyAppraisalDtoMapper;
import com.artfess.manage.safty.model.CmgtSaftyAppraisal;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.model.User;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;



/**
 * 安全目标考核 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-03
 */
@Service
public class CmgtSaftyAppraisalManagerImpl extends BaseManagerImpl<CmgtSaftyAppraisalDao, CmgtSaftyAppraisal> implements CmgtSaftyAppraisalManager {

    @Resource
    private UserDao userDao;

    @Resource
    private CmgtSaftyAppraisalDao cmgtSaftyAppraisalDao;

    @Resource
    private CmgtSaftyAppraisalDtoMapper cmgtSaftyAppraisalDtoMapper ;

    @Resource
    private ManageCommonService manageCommonService;


    @Override
    public PageList<CmgtSaftyAppraisalDto> pageQuery(QueryFilter<CmgtSaftyAppraisal> queryFilter) {
        PageList<CmgtSaftyAppraisal> result = query(queryFilter);
        PageList<CmgtSaftyAppraisalDto> r = new PageList<CmgtSaftyAppraisalDto>(
                result.getRows().stream().map(e -> {
                            CmgtSaftyAppraisalDto t = cmgtSaftyAppraisalDtoMapper.toDto(e);
                                    t.setDeptIdName(manageCommonService.getfindSelectOptionsLabel("cmgtSaftySelectOptions.getOrgs","id","name",t.getDeptId()));
                                    t.setTargetIdName(manageCommonService.getfindSelectOptionsLabel("cmgtSaftySelectOptions.getCmgtSaftyTargets","id","name",t.getTargetId()));
                                    t.setPlanTaskIdName(manageCommonService.getfindSelectOptionsLabel("cmgtSaftySelectOptions.getCmgtDutyPlanTasks","value","label",t.getPlanTaskId()));
                                    t.setUserIdName(manageCommonService.getfindSelectOptionsLabel("cmgtSaftySelectOptions.getUsers","fullname","fullname",t.getUserId()));
                                    t.setAppraisalUserName(manageCommonService.getfindSelectOptionsLabel("cmgtSaftySelectOptions.getUsers","fullname","fullname",t.getAppraisalUser()));


                            if(e.getCreateBy()!=null){
                               User user = userDao.selectById(e.getCreateBy());
                               if(user!=null){
                                   t.setCreateByName(user.getFullname());
                               }
                            }

                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(CmgtSaftyAppraisal t) {
        int i = this.baseMapper.insert(t);
        if(i>0){
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(CmgtSaftyAppraisal t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(CmgtSaftyAppraisal t) {
        this.baseMapper.deleteById(t.getId());
    }


    public String create(CmgtSaftyAppraisalDto dto) {
        CmgtSaftyAppraisal t = cmgtSaftyAppraisalDtoMapper.toEntity(dto);
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }


    public String update(CmgtSaftyAppraisalDto dto) {
        CmgtSaftyAppraisal t = cmgtSaftyAppraisalDtoMapper.toEntity(dto);
        this.baseMapper.updateById(t);


        return t.getId();
    }

    public boolean delete(List<String> ids) {
        for (String id : ids) {

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }




}
