package com.artfess.manage.safty.manager;


import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.safty.manager.dto.CmgtSaftyTrainingRecordDetailDto;
import com.artfess.manage.safty.model.CmgtSaftyTrainingRecordDetail;

import java.util.List;

/**
 * 安全培训记录人员明细 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-03
 */
public interface CmgtSaftyTrainingRecordDetailManager extends BaseManager<CmgtSaftyTrainingRecordDetail> {

    /**
     * 条件分页查询
     * @param queryFilter
     * @return
     */
    PageList<CmgtSaftyTrainingRecordDetailDto> pageQuery(QueryFilter<CmgtSaftyTrainingRecordDetail> queryFilter);

    /**
     * 新增
     * @param t
     * @return
     */
    String createInfo(CmgtSaftyTrainingRecordDetail t);

    /**
     * 更新
     * @param t
     * @return
     */
    String updateInfo(CmgtSaftyTrainingRecordDetail t);

    /**
     * 删除
     * @param t
     */
    void deleteInfo(CmgtSaftyTrainingRecordDetail t);


    String create(CmgtSaftyTrainingRecordDetailDto dto);

    String update(CmgtSaftyTrainingRecordDetailDto dto);

    boolean delete(List<String> ids);


    /**
     *
     * @param trainingId
     * @return
     */
    List<CmgtSaftyTrainingRecordDetail> selectListByTrainingId(String trainingId) ;

}
