package com.artfess.manage.material.dao;

import com.artfess.manage.material.model.CmgtMaterialWarehouseInout;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;

import java.math.BigDecimal;
import java.util.Map;

/**
 * 物资出入库单 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-07-25
 */
public interface CmgtMaterialWarehouseInoutDao extends BaseMapper<CmgtMaterialWarehouseInout> {

    /**
     * 修改库存值：入库
     * @param wid
     * @return
     */
    public Boolean addQuantity(String wid);

    /**
     * 修改库存值：出库
     * @param
     * @return
     */
    public Boolean subtractQuantity(Map params);

    /**
     * 修改领用单时检查库存数目是否足够
     * @param  params wid 领用单ID  mid 物资ID nowNum 领取数量
     * @return
     */
    public BigDecimal getQuantity(Map params);

}
