package com.artfess.manage.job;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.job.api.IJobLogService;
import com.artfess.job.model.BaseJob;
import com.artfess.job.model.SysJobLog;
import com.artfess.manage.base.dao.CmgtBasePositionDao;
import com.artfess.manage.base.model.CmgtBasePosition;
import com.artfess.manage.duty.dao.CmgtDutyJobDao;
import com.artfess.manage.duty.manager.CmgtDutyVehicleGpsinfoManager;
import com.artfess.manage.duty.manager.CmgtDutyWorkarrangeManager;
import com.artfess.manage.duty.manager.dto.CmgtDutyTeamMemberDto;
import com.artfess.manage.duty.model.CmgtDutyJob;
import com.artfess.manage.dwd.dao.DwdSjBusDepartedDao;
import com.artfess.manage.dwd.dao.DwdSjCqEventDao;
import com.artfess.manage.dwd.dao.DwdSjFestivalHolidayDao;
import com.artfess.manage.dwd.dao.DwdSjStationArrivedDao;
import com.artfess.manage.dwd.manager.DwdSjWeatherForcastMiManager;
import com.artfess.manage.dwd.model.DwdSjBusDeparted;
import com.artfess.manage.dwd.model.DwdSjCqEvent;
import com.artfess.manage.dwd.model.DwdSjFestivalHoliday;
import com.artfess.manage.dwd.model.DwdSjStationArrived;
import com.artfess.manage.utils.GeoUtils;
import com.artfess.manage.utils.SignUtils;
import com.artfess.rocketmq.producer.RocketMQProducer;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class CmgtDataCenterSyncJob extends BaseJob {

    @Resource
    private CmgtDutyWorkarrangeManager cmgtDutyWorkarrangeManager;

    @Resource
    private CmgtDutyVehicleGpsinfoManager cmgtDutyVehicleGpsinfoManager;

    @Resource
    private CmgtDutyJobDao cmgtDutyJobDao;

    @Resource
    private RocketMQProducer rocketMQProducer;

    protected Logger logger = LoggerFactory.getLogger(CmgtDataCenterSyncJob.class);

    @Resource
    private DwdSjWeatherForcastMiManager dwdSjWeatherForcastMiManager;

    @Resource
    private CmgtBasePositionDao cmgtBasePositionDao;

    @Resource
    private DwdSjStationArrivedDao dwdSjStationArrivedDao;

    @Resource
    private DwdSjBusDepartedDao dwdSjBusDepartedDao;

    @Resource
    private DwdSjCqEventDao dwdSjCqEventDao;


    @Resource
    private DwdSjFestivalHolidayDao dwdSjFestivalHolidayDao;

    private void addOperLog(String jobName, String trigName, LocalDateTime startTime,
                        LocalDateTime endTime, long runTime,String content,Integer state)   {
        IJobLogService logService= AppUtil.getBean(IJobLogService.class);
        SysJobLog jobLog=new SysJobLog(jobName, trigName, startTime, endTime, content, state,runTime);
        String id= UniqueIdUtil.getSuid();
        jobLog.setId(id);
        logService.createLog(jobLog);
    }


    public void executeJob(JobExecutionContext context) {



        //记录日志
        long startTime=System.currentTimeMillis();
        LocalDateTime strStartTime=LocalDateTime.now();

        log.info(new Date() + "======begin=====jobDataMap===syncHoliday=========" + context);

        //syncHoliday();

        //this.findCurrentDutyStaff();
        //cmgtDutyWorkarrangeManager.createSumilatedTeamMemberLoationData();
        //同步中台数据
        for (int k = 0; k > -1000; k--) {
            // syncDwdSjEventData(k);
            //syncStationArrivedData(k);
            //syncDwdSjBusDeparted(k);
        }


        long runTime=(System.currentTimeMillis()-startTime) /1000;

        addOperLog(context.getJobDetail().getKey().getName(), "CmgtDataCenterSync", strStartTime, LocalDateTime.now(), runTime, "中台数据同步", SysJobLog.STATE_YES);

        log.info(new Date() + "======end=====jobDataMap===syncHoliday=========");
    }


    public void executeJob1(JobExecutionContext context) {

        //同步中台数据
        for (int k = -1; k > -1000; k--) {
            syncDwdSjEventData(k);
            syncStationArrivedData(k);
            syncDwdSjBusDeparted(k);
        }
        //获取上下文参数。
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        System.out.println(new Date() + "===========jobDataMap============" + jobDataMap);
        //创建车辆位置模拟数据
        cmgtDutyVehicleGpsinfoManager.createSumilatedGpsData();

        //创建人员位置信息
        cmgtDutyWorkarrangeManager.createSumilatedTeamMemberLoationData();
        //context.getJobDetail().getJobDataMap()

        //创建事故易发点
        createAccidentPoint();
        logger.info("定时计划测试正常com.artfess.job.job.MyJob");
        System.out.println(new Date() + "======CmgtDataCenterSyncJob=====定时计划测试完成===========");
    }

    public static String arrDate = null;

    public JSONArray findCurrentDutyStaff() {
        if (arrDate != null && arrDate.equals(DateUtil.today())) {
            // return null;
        }
        String arrDate = DateUtil.today();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH:mm");
        JSONArray r = JSONUtil.createArray();
        cmgtDutyWorkarrangeManager.findCmgtDutyWorkarrangeDtosBy(arrDate).forEach(t -> {
            for (CmgtDutyTeamMemberDto member : t.getTeamMembers()) {
                r.add(JSONUtil.createObj().putOpt("dutyDate", arrDate)
                        .putOpt("dutyStart", (t.getCmgtDutyWorkclass().getScheduleStart() != null ? t.getCmgtDutyWorkclass().getScheduleStart().format(dtf) : ""))
                        .putOpt("dutyEnd", (t.getCmgtDutyWorkclass().getDuringTime() != null ? t.getCmgtDutyWorkclass().getDuringTime().format(dtf) : ""))
                        .putOpt("name", member.getName())
                        .putOpt("sex", member.getSex())
                        .putOpt("post", member.getPost())
                        .putOpt("phone", member.getPhone())
                        .putOpt("org", member.getOrg().getName())
                        .putOpt("team", t.getCmgtDutyTeam().getName())
                );
            }
        });
        System.out.println("====================toStringPretty============" + r.toStringPretty());
        rocketMQProducer.send("zhyw_duty_staff_topic", r.toStringPretty());
        return r;
    }

    /**
     * 创建模拟事件易发点位
     */
    @Transactional
    private void createAccidentPoint() {
        QueryWrapper<CmgtBasePosition> queryWrapper = new QueryWrapper();
        queryWrapper.eq("DTYPE_", "ACCIDENT");
        queryWrapper.between("RECEIVE_TIME_", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 00:00:00",
                LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 23:59:59");
        List<CmgtBasePosition> l = cmgtBasePositionDao.selectList(queryWrapper);
        if (l.size() < 3) {
            CmgtBasePosition position = new CmgtBasePosition();
            position.setDtype("ACCIDENT");
            position.setReceiveTime(LocalDateTime.now());
            position.setReceiveTime(LocalDateTime.now());
            position.setMemo("随机生成模拟数据");
            position.setLatitude(RandomUtil.randomBigDecimal(BigDecimal.valueOf(106.537288), BigDecimal.valueOf(106.55633)) + "");
            position.setLongitude(RandomUtil.randomBigDecimal(BigDecimal.valueOf(29.606626), BigDecimal.valueOf(29.615619)) + "");
            position.setName("事故易发点(" + (l.size() + 1) + ")");
            cmgtBasePositionDao.insert(position);
        }
    }

    /**
     * 同步数据中台的到达数据
     */
    @Transactional
    private void syncStationArrivedData(Integer k) {
        if (k == null) {
            k = -1;
        }
        String dataTime = DateUtil.format(DateUtil.offsetDay(DateUtil.date(), k), "yyyy-MM-dd");
        QueryWrapper<DwdSjStationArrived> queryWrapper = new QueryWrapper();
        queryWrapper.between("date_time_", dataTime + " 00:00:00", dataTime + " 23:59:59");
        int count = dwdSjStationArrivedDao.selectCount(queryWrapper);
        if (count > 0) {
            return;
        }
        String reqParam = "{\"param\":{\"date_time_start\":\"" + dataTime + " 00:00:00\",\"date_time_end\":\"" + dataTime + " 23:59:59\"}}";

        //reqParam = "{\"param\":{\"date_time_start\":\"2021-06-01 \",\"date_time_end\":\"2021-06-02\"}}";

        //国铁重庆北站-历史到达人数
        String APPID = "b8fff05a_bf88_4391_8967_fa19364c";//b8fff05a_bf88_4391_8967_fa19364c
        String APPKEY = "38553d72d3a0480eb0aad7e9cfe4a48a"; //38553d72d3a0480eb0aad7e9cfe4a48a
        String APPURL = "http://222.180.171.219/api/oapigw/api/oapisvc/automicApi/7fe4711997514f07b6726f9926dca53a";

        try {

            String timestamp = System.currentTimeMillis() + "";
            Map<String, String> map = new HashMap<String, String>();
            map.put("timestamp", timestamp);
            map.put("appid", APPID);
            StringBuilder signBuilder = new StringBuilder().append("appid=").append(APPID).append("&")
                    .append(reqParam).append("&")
                    .append("timestamp=").append(timestamp).append("&")
                    .append("key=").append(APPKEY);
            map.put("sign", SignUtils.HMACSHA256(signBuilder.toString(), APPKEY));
            HttpResponse r = HttpUtil.createPost(APPURL).contentType("application/json").addHeaders(map).body(reqParam).execute();
            JSONObject result = JSONUtil.parseObj(r.body());
            if (result.getInt("code") == 200) {
                JSONArray list = result.getJSONObject("data").getJSONArray("list");
                if (list.size() > 0) {
                    list.forEach(item -> {
                        DwdSjStationArrived arrived = JSONUtil.toBean((JSONObject) item, DwdSjStationArrived.class);
                        dwdSjStationArrivedDao.insert(arrived);
                    });
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * 长途汽车-长途汽车历史发车
     */
    @Transactional
    private void syncDwdSjBusDeparted(Integer k) {

        if (k == null) {
            k = -1;
        }
        String dataTime = DateUtil.format(DateUtil.offsetDay(DateUtil.date(), k), "yyyy-MM-dd");
        String reqParam = "{\"param\":{\"departure_date_start\":\"" + dataTime + " 00:00:00\",\"departure_date_end\":\"" + dataTime + " 23:59:59\"}}";

        QueryWrapper<DwdSjBusDeparted> queryWrapper = new QueryWrapper();
        queryWrapper.between("departure_date", dataTime + " 00:00:00", dataTime + " 23:59:59");
        int count = dwdSjBusDepartedDao.selectCount(queryWrapper);
        if (count > 0) {
            return;
        }

        //reqParam = "{\"param\":{\"departure_date_start\":\"2021-06-01 \",\"departure_date_end\":\"2022-06-02\"}}";

        String APPID = "b8fff05a_bf88_4391_8967_fa19364c";
        String APPKEY = "38553d72d3a0480eb0aad7e9cfe4a48a";
        String APPURL = "http://222.180.171.219/api/oapigw/api/oapisvc/automicApi/0533b85a9cbe4994ad99f3ea95b786ff";

        try {
            String timestamp = System.currentTimeMillis() + "";
            Map<String, String> map = new HashMap<String, String>();
            map.put("timestamp", timestamp);
            map.put("appid", APPID);
            StringBuilder signBuilder = new StringBuilder().append("appid=").append(APPID).append("&")
                    .append(reqParam).append("&")
                    .append("timestamp=").append(timestamp).append("&")
                    .append("key=").append(APPKEY);
            map.put("sign", SignUtils.HMACSHA256(signBuilder.toString(), APPKEY));
            HttpResponse r = HttpUtil.createPost(APPURL).contentType("application/json").addHeaders(map).body(reqParam).execute();
            JSONObject result = JSONUtil.parseObj(r.body());
            System.out.println("=====syncDwdSjBusDeparted===result=============" + result);
            if (result.getInt("code") == 200) {
                JSONArray list = result.getJSONObject("data").getJSONArray("list");
                if (list.size() > 0) {
                    list.forEach(item -> {
                        DwdSjBusDeparted departed = JSONUtil.toBean((JSONObject) item, DwdSjBusDeparted.class);
                        dwdSjBusDepartedDao.insert(departed);
                    });
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * 事件中心-所有事件
     */
    @Transactional
    private void syncDwdSjEventData(Integer k) {

        if (k == null) {
            k = -1;
        }
        String dataTime = DateUtil.format(DateUtil.offsetDay(DateUtil.date(), k), "yyyy-MM-dd");
        String reqParam = "{\"startTime\":\"" + dataTime + " 00:00:00\",\"endTime\":\"" + dataTime + " 23:59:59\"}";

//        QueryWrapper<DwdSjBusDeparted> queryWrapper = new QueryWrapper();
//        queryWrapper.between("departure_date", dataTime + " 00:00:00", dataTime + " 23:59:59");
//        int count = dwdSjBusDepartedDao.selectCount(queryWrapper);
//        if (count > 0) {
//            return;
//        }

        //reqParam = "{\"param\":{\"departure_date_start\":\"2021-06-01 \",\"departure_date_end\":\"2022-06-02\"}}";

        String APPID = "b8fff05a_bf88_4391_8967_fa19364c";//b8fff05a_bf88_4391_8967_fa19364c
        String APPKEY = "38553d72d3a0480eb0aad7e9cfe4a48a";
        String APPURL = "http://222.180.171.219/api/oapigw/api/oapisvc/v1/aggapi/ab910d51287f445187b0cd2de850429b";

        try {
            String timestamp = System.currentTimeMillis() + "";
            Map<String, String> map = new HashMap<String, String>();
            map.put("timestamp", timestamp);
            map.put("appid", APPID);
            StringBuilder signBuilder = new StringBuilder().append("appid=").append(APPID).append("&")
                    .append(reqParam).append("&")
                    .append("timestamp=").append(timestamp).append("&")
                    .append("key=").append(APPKEY);
            map.put("sign", SignUtils.HMACSHA256(signBuilder.toString(), APPKEY));
            HttpResponse r = HttpUtil.createPost(APPURL).contentType("application/json").addHeaders(map).body(reqParam).execute();
            JSONObject result = JSONUtil.parseObj(r.body());

            System.out.println(reqParam + "====" + k + "=syncDwdSjEventData===result=============" + result);
            List<CmgtDutyJob> jobs = cmgtDutyJobDao.selectList(null);
            if (result.getInt("code") == 200) {
                JSONArray list = result.getJSONObject("data").getJSONArray("list");
                if (list.size() > 0) {
                    list.forEach(item -> {
                        JSONObject oitem = (JSONObject) item;
                        if (oitem.get("handleUserList") != null) {
                            System.out.println(oitem.get("handleUserList") + "====k=syncDwdSjEventData===handleUserList1111=============" + result);
                        }
                        int count = dwdSjCqEventDao.selectCount((new QueryWrapper<DwdSjCqEvent>().eq("event_id", oitem.getStr("eventId"))));
                        if (count == 0) {
                            DwdSjCqEvent sjCqEvent = JSONUtil.toBean(oitem, DwdSjCqEvent.class);
                            if (sjCqEvent.getLnglat() != null) {
                                for (CmgtDutyJob j : jobs) {
                                    if (GeoUtils.pointInPolygon(sjCqEvent.getLnglat(), j.getArea())) {
                                        sjCqEvent.setDutyJobId(j.getId());
                                    }
                                }
                            }
                            if (sjCqEvent.getDutyJobId() == null && StringUtil.isNotEmpty(sjCqEvent.getRegionId())) {
                                if (sjCqEvent.getRegionId().indexOf("CQBZ_BGC_F1_011") >= 0) {
                                    sjCqEvent.setDutyJobId("1569950581555073024");
                                } else if (sjCqEvent.getRegionId().indexOf("CQBZ_TL") >= 0) {
                                    sjCqEvent.setDutyJobId("1568250985745354752");
                                } else if (sjCqEvent.getRegionId().indexOf("CQBZ") >= 0) {
                                    sjCqEvent.setDutyJobId("1568213830826332160");
                                }
                            } else {
                                sjCqEvent.setDutyJobId("1569950465930694656");
                            }
                            dwdSjCqEventDao.insert(sjCqEvent);
                        }
                    });
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private static boolean finishSyncHoliday = false;

    @Transactional
    private void syncHoliday() {
        if (finishSyncHoliday) {
            return;
        }
        finishSyncHoliday = true;

        Map<String, Object> param = new HashMap<String, Object>() {{
            put("key", "b9bd81f0d27995863f2104a68259a02a");//这里key值是注册天行API账号是给的
            put("type", 1);
        }};
        //获取当前年份，循环调用3次，拿到3年的数据
        int currentYear = Calendar.getInstance().get(Calendar.YEAR);
        for (int i = 0; i < 3; i++) {
            param.put("date", currentYear - i);
            String url = "http://api.tianapi.com/jiejiari/index";
            String response = HttpUtil.get(url, param);
            JSONObject resObj = JSONUtil.parseObj(response);

            System.out.println(new Date() + "===========jobDataMap===syncHoliday===resObj======" + resObj);

            int code = (int) resObj.get("code");
            if (code == 200) {
                JSONArray newslist = (JSONArray) resObj.get("newslist");
                for (Object listObj : newslist) {
                    JSONObject obj = (JSONObject) listObj;
                    String holidays = (String) obj.get("vacation");
                    String[] holidayArray = holidays.split("\\|");

                    for (int k = 0; k < holidayArray.length; k++) {
                        int count = dwdSjFestivalHolidayDao.selectCount((new QueryWrapper<DwdSjFestivalHoliday>().eq("vacation_date_", holidayArray[k])));
                        System.out.println(new Date() + "===========jobDataMap===syncHoliday===resObj====count==" + count);
                        if (count == 0) {
                            DwdSjFestivalHoliday h = new DwdSjFestivalHoliday();
                            h.setVacationDate(holidayArray[k]);
                            h.setContent(obj.toStringPretty());
                            h.setHoliday(obj.getStr("holiday"));
                            h.setName(obj.getStr("name"));
                            h.setTip(obj.getStr("tip"));
                            h.setRest(obj.getStr("rest"));
                            h.setSn(k);
                            dwdSjFestivalHolidayDao.insert(h);
                        }
                    }
                }
            }
        }
    }
}
