package com.artfess.manage.dwd.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;



/**
 * dwd_lk_family_member
 *
 * @company 阿特菲斯信息技术有限公司Base
 * @author yuanhc
 * @since 2022-11-06
 */
@Data
@ApiModel(value="DwdLkFamilyMember对象", description="家庭成员")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class DwdLkFamilyMember extends BaseModel<DwdLkFamilyMember> {

    /** 主建ID */
    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    /** 创建人电话 */
    @ApiModelProperty(value = "创建人电话")
    @TableField("phone")
    @NotBlank(message = "创建人电话",groups = {AddGroup.class,UpdateGroup.class})
    private String phone;

    /** 创建人 */
    @ApiModelProperty(value = "创建人")
    @TableField("user_id")
    private String userId;

    /** 成员姓名 */
    @ApiModelProperty(value = "成员姓名")
    @TableField("name")
    @NotBlank(message = "成员姓名",groups = {AddGroup.class,UpdateGroup.class})
    private String name;

    /** 成员身份证号 */
    @ApiModelProperty(value = "成员身份证号")
    @TableField("id_card")
    private String idCard;


}
