package com.artfess.manage.duty.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;
import java.time.LocalTime;

/**
 * 班种信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-07-21
 */
@Data
@ApiModel(value="CmgtDutyWorkclass对象", description="班种信息")
public class CmgtDutyWorkclass extends AutoFillModel<CmgtDutyWorkclass> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "班种名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "班种名称")
    @TableField("NAME")
    private String name;

    @NotBlank(message = "班种别名",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "班种别名")
    @TableField("ALIAS_")
    private String alias;

    @NotBlank(message = "归属部门ID",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "归属部门ID")
    @TableField("ORG_ID_")
    private String orgId;

    @NotBlank(message = "归属部门名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "归属部门名称")
    @TableField("ORG_NAME_")
    private String orgName;

    @DateTimeFormat(pattern = "HH:mm")
    @JsonFormat(pattern = "HH:mm",timezone="GMT+8")
    @ApiModelProperty(value = "上班开始时间")
    @TableField("SCHEDULE_START_")
    private LocalTime scheduleStart;

    @DateTimeFormat(pattern = "HH:mm")
    @JsonFormat(pattern = "HH:mm",timezone="GMT+8")
    @ApiModelProperty(value = "此班持续时间")
    @TableField("DURING_TIME_")
    private LocalTime duringTime;

    @ApiModelProperty(value = "该班后休息(h)")
    @TableField("AFTER_REST_")
    private Integer afterRest;

    @ApiModelProperty(value = "此班频率要求(天)")
    @TableField("DIFF_DAYS_")
    private Integer diffDays;

    @ApiModelProperty(value = "该班人员是否可缺省")
    @TableField("NUMBER_MUST_")
    private String numberMust;

    @ApiModelProperty(value = "星期分布（勾选需排人，否则不排）")
    @TableField(value = "WEEKS_")
    private String weeks;

    @ApiModelProperty(value = "状态(仅“正常”会被排班)")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "显示颜色")
    @TableField("SHOW_COLOR_")
    private String showColor;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "备注")
    @TableField("MEMO_")
    private String memo;

    @TableLogic
    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

//    @ApiModelProperty(value = "创建人机构ID")
//    @TableField("CREATE_ORG_ID_")
//    private String createOrgId;
//
//    @ApiModelProperty(value = "创建人")
//    @TableField("CREATE_BY_")
//    private String createBy;
//
//    @ApiModelProperty(value = "创建时间")
//    @TableField("CREATE_TIME_")
//    private LocalDateTime createTime;
//
//    @ApiModelProperty(value = "修改人员")
//    @TableField("UPDATE_BY_")
//    private String updateBy;
//
//    @ApiModelProperty(value = "修改时间")
//    @TableField("UPDATE_TIME_")
//    private LocalDateTime updateTime;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Integer version;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("LAST_TIME_")
    private LocalDateTime lastTime;

}
