package com.artfess.manage.duty.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * cmgt_duty_workarrange
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-07-28
 */
@Data
@ApiModel(value="CmgtDutyWorkarrange对象", description="排班信息")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class CmgtDutyWorkarrange extends AutoFillModel<CmgtDutyWorkarrange> {

    /** 主键_ID */
    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    /** 排班日期 */
    @ApiModelProperty(value = "排班日期")
    @TableField("arrange_date_")
    @NotNull(message = "排班日期",groups = {AddGroup.class,UpdateGroup.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone="GMT+8")
    private LocalDate arrangeDate;

    /** 班种 */
    @ApiModelProperty(value = "班种")
    @TableField("workclass_id_")
    @NotBlank(message = "班种",groups = {AddGroup.class,UpdateGroup.class})
    private String workclassId;

    /** 所属部门  */
    @ApiModelProperty(value = "所属部门")
    @TableField("org_id_")
    private String orgId;

    /** 数据类型（0:人、1:组） */
    @ApiModelProperty(value = "数据类型（0:人、1:组）")
    @TableField("data_type_")
    private String dataType;

    /** 队员ID */
    @ApiModelProperty(value = "队员ID")
    @TableField("teammember_id_")
    private String teammemberId;

    /** 队员ID */
    @ApiModelProperty(value = "队员名字")
    @TableField("teammember_names_")
    private String teammemberNames;

    /** 小组ID */
    @ApiModelProperty(value = "小组ID")
    @TableField("team_id__")
    private String teamId;

    /** 状态 */
    @ApiModelProperty(value = "状态")
    @TableField("status_")
    private String status;

    /** 出勤情况 */
    @ApiModelProperty(value = "出勤情况")
    @TableField("attendance_")
    private String attendance;

    /** 排序 */
    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    /** 备注 */
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    /** 删除标识，1已删除，0未删除 */
    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    @TableField("is_dele_")
    private String isDele;

//
//    /** 创建人 */
//    @ApiModelProperty(value = "创建人")
//    @TableField("create_by_")
//    private String createBy;
//
//    /** 创建人机构ID */
//    @ApiModelProperty(value = "创建人机构ID")
//    @TableField("create_org_id_")
//    private String createOrgId;
//
//    /** 创建时间 */
//    @ApiModelProperty(value = "创建时间")
//    @TableField("create_time_")
//    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
//    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
//    private LocalDateTime createTime;
//
//    /** 修改人员 */
//    @ApiModelProperty(value = "修改人员")
//    @TableField("update_by_")
//    private String updateBy;
//
//    /** 修改时间 */
//    @ApiModelProperty(value = "修改时间")
//    @TableField("update_time_")
//    private LocalDateTime updateTime;

    /** 版本号 */
    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    /** 数据时间戳 */
    @ApiModelProperty(value = "数据时间戳")
    @TableField("last_time_")
    private LocalDateTime lastTime;


}
