package com.artfess.manage.duty.model;

import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.base.ManageBaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;

/**
 * cmgt_duty_job
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-09-09
 */
@Data
@ApiModel(value="CmgtDutyJob对象", description="勤务岗位信息")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class CmgtDutyJob extends ManageBaseModel<CmgtDutyJob> {


    /** 主键_ID */
    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    /** 编号 */
    @ApiModelProperty(value = "编号")
    @TableField("code_")
    private String code;

    /** 名称 */
    @ApiModelProperty(value = "名称")
    @TableField("name_")
    @NotBlank(message = "名称",groups = {AddGroup.class,UpdateGroup.class})
    private String name;

    /** 岗位别名 */
    @ApiModelProperty(value = "岗位别名")
    @TableField("alias_")
    private String alias;

    /** 职责描述 */
    @ApiModelProperty(value = "职责描述")
    @TableField("description_")
    private String description;

    /** 负责区域 */
    @ApiModelProperty(value = "负责区域")
    @TableField("area_")
    private String area;

    /** 排序 */
    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    /** 备注 */
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    /** 组织ID */
    @ApiModelProperty(value = "组织ID")
    @TableField("org_id_")
    private String orgId;

    /** 组织名称 */
    @ApiModelProperty(value = "组织名称")
    @TableField("org_name_")
    private String orgName;

}
