package com.artfess.manage.duty.manager.impl;


import com.artfess.manage.duty.model.CmgtDutyOrgWorkarrange;
import com.artfess.manage.duty.manager.dto.CmgtDutyOrgWorkarrangeDto;
import com.artfess.manage.duty.manager.mapper.CmgtDutyOrgWorkarrangeDtoMapper;
import com.artfess.manage.duty.dao.CmgtDutyOrgWorkarrangeDao;
import com.artfess.manage.duty.manager.CmgtDutyOrgWorkarrangeManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.uc.manager.DemensionManager;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Demension;
import com.artfess.uc.model.Org;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.artfess.manage.base.ManageCommonService;



/**
 * 部门排班信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-08-11
 */
@Service
public class CmgtDutyOrgWorkarrangeManagerImpl extends BaseManagerImpl<CmgtDutyOrgWorkarrangeDao, CmgtDutyOrgWorkarrange> implements CmgtDutyOrgWorkarrangeManager {

    @Resource
    private CmgtDutyOrgWorkarrangeDao cmgtDutyOrgWorkarrangeDao;

    @Resource
    private CmgtDutyOrgWorkarrangeDtoMapper cmgtDutyOrgWorkarrangeDtoMapper ;

    @Resource
    private ManageCommonService manageCommonService;

    @Resource
    DemensionManager demensionService;

    @Autowired
    OrgManager orgService;


    @Override
    public PageList<CmgtDutyOrgWorkarrangeDto> pageQuery(QueryFilter<CmgtDutyOrgWorkarrange> queryFilter) {
        PageList<CmgtDutyOrgWorkarrange> result = query(queryFilter);
        PageList<CmgtDutyOrgWorkarrangeDto> r = new PageList<CmgtDutyOrgWorkarrangeDto>(
                result.getRows().stream().map(e -> {
                            CmgtDutyOrgWorkarrangeDto t = cmgtDutyOrgWorkarrangeDtoMapper.toDto(e);
                            //t.setNameName(manageCommonService.getfindSelectOptionsLabel("cmgtDutySelectOptions.getCmgtDutyVehicles","value","label",t.getName()));
                            t.setOrgName(orgService.getById(t.getOrgId()).getName());
                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setPageSize(result.getPageSize());
        r.setPageSize(result.getPage());
        return r;
    }

    @Override
    public String createInfo(CmgtDutyOrgWorkarrange t) {
        int i = this.baseMapper.insert(t);
        if(i>0){
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(CmgtDutyOrgWorkarrange t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(CmgtDutyOrgWorkarrange t) {
        this.baseMapper.deleteById(t.getId());
    }


    public String create(CmgtDutyOrgWorkarrangeDto dto) {
        CmgtDutyOrgWorkarrange t = cmgtDutyOrgWorkarrangeDtoMapper.toEntity(dto);
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }


    public String update(CmgtDutyOrgWorkarrangeDto dto) {
        CmgtDutyOrgWorkarrange t = cmgtDutyOrgWorkarrangeDtoMapper.toEntity(dto);
        this.baseMapper.updateById(t);


        return t.getId();
    }

    public boolean delete(List<String> ids) {
        for (String id : ids) {

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public List<Map<String, Object>> getAllOrgTree() {
        //查找所有维度
//        List<Demension> demAll = demensionService.getAll();
        List<Map<String,Object>> rootNode = new  ArrayList();
//        //查找每个维度下的组织信息
//        demAll.stream().forEach(d->{
//
//        });

        Map<String,Object> r = new HashMap<>();
        List<Org> rootOrgList =  orgService.getOrgsByparentId("1");
        if(rootOrgList.size()==0){
            rootOrgList =  orgService.getOrgsByparentId("0");
        }
        Org d = rootOrgList.get(0);
        r.put("id",d.getId());
        r.put("name",d.getName());
        r.put("demId",d.getDemId());
        //查询
        QueryFilter filter = QueryFilter.build();
        filter.addParams("parentId","('"+d.getId()+"')");
        filter.addParams("demId",d.getDemId());
        List<Org> childrenOrg = orgService.getByParentAndDem(filter);
        System.out.println(d+"==========d.getId()========="+childrenOrg);
        List<Map<String,Object>> children = new  ArrayList();
        childrenOrg.stream().forEach(child->{
            Map<String,Object> c = new HashMap<>();
            c.put("id",child.getId());
            c.put("name",child.getName());
            c.put("demId",child.getDemId());
            c.put("children",findchildrenNode(child.getId()));
            c.put("parentId",d.getId());
            children.add(c);
        });
        r.put("children",children);
        r.put("parentId",d.getId());
        rootNode.add(r);

        return  rootNode;
    }

    /**
     * 获取所有部门排班表信息
     * @return
     */
    @Override
    public List<CmgtDutyOrgWorkarrange> findAll() {
        return this.getAll();
    }

    /**
     * 根据父ID查找下级节点
     * @param pid
     * @return
     */
    public List<Map<String,Object>> findchildrenNode(String pid){
        List<Org> childrenOrg = orgService.getOrgsByparentId(pid);
        List<Map<String,Object>> children = new  ArrayList();
        childrenOrg.stream().forEach(child->{
            Map<String,Object> c = new HashMap<>();
            c.put("id",child.getId());
            c.put("name",child.getName());
            c.put("demId",child.getDemId());
            c.put("children",this.findchildrenNode(child.getId()));
            c.put("parentId",pid);
            children.add(c);
        });
        return children;
    }

}
