package com.artfess.manage.base;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.typehandle.StringConvert2IntHandler;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModelProperty.AccessMode;

import javax.xml.bind.annotation.XmlTransient;
import java.time.LocalDateTime;

/**
 * 带自动填充字段的基础实体类
 *
 * @author yuanhc
 * @company 阿特菲斯信息技术有限公司
 * @email heyf@jee-soft.cn
 * @date 2022年9月3日
 */
public abstract class ManageBaseModel<T extends ManageBaseModel<?>> extends BaseModel<T> {
    private static final long serialVersionUID = 1L;

    //@JsonIgnore
    @ApiModelProperty(value = "创建人ID", hidden = true, accessMode = AccessMode.READ_ONLY)
    @TableField(updateStrategy = FieldStrategy.NOT_NULL, value = "create_by_", fill = FieldFill.INSERT, select = true)
    private String createBy;

    //@JsonIgnore
    @ApiModelProperty(value = "创建人组织ID", hidden = true, accessMode = AccessMode.READ_ONLY)
    @TableField(updateStrategy = FieldStrategy.NOT_NULL, value = "create_org_id_", fill = FieldFill.INSERT, select = true)
    private String createOrgId;

    @ApiModelProperty(value = "创建时间", hidden = true, accessMode = AccessMode.READ_ONLY)
    @TableField(updateStrategy = FieldStrategy.NOT_NULL, value = "create_time_", fill = FieldFill.INSERT, select = true)
    private LocalDateTime createTime;

    //@JsonIgnore
    @ApiModelProperty(value = "更新人ID", hidden = true, accessMode = AccessMode.READ_ONLY)
    @TableField(updateStrategy = FieldStrategy.NOT_NULL, value = "update_by_", fill = FieldFill.UPDATE, select = true)
    private String updateBy;

    //@JsonIgnore
    @ApiModelProperty(value = "更新时间", hidden = true, accessMode = AccessMode.READ_ONLY)
    @TableField(updateStrategy = FieldStrategy.NOT_NULL, value = "update_time_", fill = FieldFill.UPDATE, select = true)
    private LocalDateTime updateTime;

    /**
     * 是否已删除 0：未删除 1：已删除
     */
    //@TableLogic
    @TableField(value = "IS_DELE_", typeHandler = StringConvert2IntHandler.class)
    @ApiModelProperty(name = "isDelete", notes = "是否已删除 0：未删除 1：已删除（新增、更新数据时不需要传入）")
    protected String isDelete = "0";

    /**
     * 版本号
     */
    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    /**
     * 数据时间戳
     */
    @ApiModelProperty(value = "数据时间戳")
    @TableField("last_time_")
    private LocalDateTime lastTime;

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public String getCreateOrgId() {
        return createOrgId;
    }

    public void setCreateOrgId(String createOrgId) {
        this.createOrgId = createOrgId;
    }

    @XmlTransient
    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    @XmlTransient
    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public String getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(String isDelete) {
        this.isDelete = isDelete;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @XmlTransient
    public LocalDateTime getLastTime() {
        return lastTime;
    }

    public void setLastTime(LocalDateTime lastTime) {
        this.lastTime = lastTime;
    }


    @Override
    public String toString() {
        return "BaseModel{" +
                ", createBy=" + createBy +
                ", createOrgId=" + createOrgId +
                ", createTime=" + createTime +
                ", updateBy=" + updateBy +
                ", updateTime=" + updateTime +
                ", isDelete=" + isDelete +
                "}";
    }
}
