package com.artfess.file.persistence.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.file.model.FileConfig;
import com.artfess.file.model.FileStorage;
import com.artfess.file.model.FlowUploadProperties;

/*
* @Description: 系统附件存储配置 处理接口
* @Author: chens
* @Date: 2021/6/8 10:31
*/
public interface FileStorageManager extends BaseManager<FileStorage>{
	/**
	 * @Description:  保存系统附件存储配置
	 * @param fileStorage  系统附件存储配置
	 * @Return: java.lang.String
	 * @Author: chens
	 * @Date: 2020/5/6 17:10
	 */
	String insertFileStorage(FileStorage fileStorage);


	/**
	 * @Description: 修改系统附件存储配置
	 * @param fileStorage   系统附件存储配置
	 * @Return: java.lang.String
	 * @Author: chens
	 * @Date: 2020/5/7 10:39
	 */
	String updateFileStorage(FileStorage fileStorage);

	/**
	 * 批量删除系统附件存储配置
	 * @param ids
	 */
	String deleteFileStorage(String ...ids);

	/**
	 * 根据编码获取附件存储配置方式
	 * @param code
	 * @return
	 */
	FileStorage getByCode(String code);
}
