/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.device.base.dao.AppraiseInfoDao;
import com.artfess.device.base.manager.AppraiseDetailsManager;
import com.artfess.device.base.manager.AppraiseInfoManager;
import com.artfess.device.base.manager.DeviceBaseCompanyManager;
import com.artfess.device.base.manager.DeviceBaseContractManager;
import com.artfess.device.base.model.AppraiseDetails;
import com.artfess.device.base.model.AppraiseInfo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class AppraiseInfoManagerImpl
extends BaseManagerImpl<AppraiseInfoDao, AppraiseInfo>
implements AppraiseInfoManager {
    @Autowired
    private AppraiseDetailsManager detailsManager;
    @Autowired
    private DeviceBaseContractManager contractManager;
    @Autowired
    private DeviceBaseCompanyManager companyManager;

    public boolean save(AppraiseInfo appraiseInfo) {
        Assert.notNull((Object)((Object)appraiseInfo), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)appraiseInfo.getAssessType(), (String)"\u8003\u6838\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)appraiseInfo.getAssessYear(), (String)"\u8003\u6838\u5e74\u5ea6\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)appraiseInfo.getAssessType(), (String)"\u8003\u6838\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)appraiseInfo.getReference(), (String)"\u88ab\u8003\u6838\u8005\u4e0d\u80fd\u4e3a\u7a7a!");
        QueryFilter<AppraiseInfo> queryFilter = this.getCheckFilter(appraiseInfo);
        queryFilter.getQuerys().add(new QueryField("dai.reference_", (Object)appraiseInfo.getReference()));
        Integer repeatCheck = this.query(queryFilter).getRows().size();
        Assert.isTrue((repeatCheck == 0 ? 1 : 0) != 0, (String)("\u3010" + appraiseInfo.getReference() + "\u3011\u5df2\u7ecf\u8003\u6838\u8fc7\u3010" + appraiseInfo.getAssessTitle() + "\u3011\uff01"));
        return this.doSave(appraiseInfo, true);
    }

    public boolean updateById(AppraiseInfo appraiseInfo) {
        return this.doSave(appraiseInfo, false);
    }

    private boolean doSave(AppraiseInfo appraiseInfo, boolean insert) {
        Assert.isTrue((appraiseInfo.getDetailsList().stream().map(AppraiseDetails::getInfoId).distinct().count() == 1L ? 1 : 0) != 0, (String)"detailsList\u4e2d\u7684infoId\u5fc5\u987b\u552f\u4e00\u3002");
        if (insert) {
            super.save((Object)appraiseInfo);
        }
        List<AppraiseDetails> details = appraiseInfo.getDetailsList();
        BigDecimal resultScore = new BigDecimal(0);
        for (AppraiseDetails d : details) {
            d.setInfoId(appraiseInfo.getId());
            this.detailsManager.getResult(d);
            resultScore = resultScore.add(d.getItemResult());
        }
        appraiseInfo.setResult(resultScore);
        boolean result = super.updateById((Object)appraiseInfo);
        this.detailsManager.saveOrUpdateBatch(appraiseInfo.getDetailsList());
        return result;
    }

    public AppraiseInfo getById(Serializable id) {
        QueryFilter queryFilter = QueryFilter.build();
        ArrayList fields = Lists.newArrayList();
        fields.add(new QueryField("dai.ID_", (Object)id));
        queryFilter.setQuerys((List)fields);
        queryFilter.setPageBean(new PageBean(Integer.valueOf(1), Integer.valueOf(1)));
        List result = this.query((QueryFilter<AppraiseInfo>)queryFilter).getRows();
        return BeanUtils.isEmpty((Object)result) ? null : (AppraiseInfo)((Object)result.get(0));
    }

    public PageList<AppraiseInfo> query(QueryFilter<AppraiseInfo> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        QueryWrapper queryWrapper = this.convert2Wrapper(queryFilter, this.currentModelClass());
        IPage<AppraiseInfo> result = ((AppraiseInfoDao)this.baseMapper).queryPage((IPage<AppraiseInfo>)this.convert2IPage(pageBean), (Wrapper<AppraiseInfo>)queryWrapper);
        List detailsList = this.detailsManager.list();
        result.getRecords().forEach(r -> {
            ArrayList<AppraiseDetails> details = new ArrayList<AppraiseDetails>();
            detailsList.forEach(dl -> {
                if (dl.getInfoId().equals(r.getId())) {
                    details.add((AppraiseDetails)((Object)((Object)dl)));
                }
            });
            r.setDetailsList(details);
        });
        return new PageList(result);
    }

    @Override
    public boolean closeInfo(String infoId) {
        return this.update((Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"ID_", (Object)infoId)).set((Object)"CLOSE_STATUS_", (Object)"1"));
    }

    @Override
    public List<String> getExaminees(AppraiseInfo dto) {
        Assert.notNull((Object)((Object)dto), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)dto.getAssessType(), (String)"\u8003\u6838\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)dto.getAssessYear(), (String)"\u8003\u6838\u5e74\u5ea6\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)dto.getAssessType(), (String)"\u8003\u6838\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a!");
        ArrayList result = Lists.newArrayList();
        ArrayList exclued = Lists.newArrayList();
        QueryFilter<AppraiseInfo> queryFilter = this.getCheckFilter(dto);
        this.query(queryFilter).getRows().forEach(d -> exclued.add(d.getReference()));
        if ("1".equals(dto.getAssessType())) {
            this.companyManager.getBaseMapper().selectList((Wrapper)new QueryWrapper().notIn(BeanUtils.isNotEmpty((Object)exclued), (Object)"COMPANY_NAME_", (Collection)exclued)).forEach(com -> result.add(com.getCompanyName()));
        } else if ("2".equals(dto.getAssessType())) {
            this.contractManager.getBaseMapper().selectList((Wrapper)new QueryWrapper().notIn(BeanUtils.isNotEmpty((Object)exclued), (Object)"CONTRACT_NAME_", (Collection)exclued)).forEach(con -> result.add(con.getContractName()));
        } else {
            Assert.isTrue((boolean)false, (String)"\u4f20\u5165\u8003\u6838\u7c7b\u578b\u6709\u8bef");
        }
        return result;
    }

    private QueryFilter<AppraiseInfo> getCheckFilter(AppraiseInfo dto) {
        QueryFilter queryFilter = QueryFilter.build();
        ArrayList querys = Lists.newArrayList();
        querys.add(new QueryField("dab.ASSESS_TITLE_", (Object)dto.getAssessTitle()));
        querys.add(new QueryField("dab.ASSESS_TYPE_", (Object)dto.getAssessType()));
        querys.add(new QueryField("dab.ASSESS_YEAR_", (Object)dto.getAssessYear()));
        queryFilter.setQuerys((List)querys);
        queryFilter.setPageBean(new PageBean(Integer.valueOf(1), Integer.valueOf(-1)));
        return queryFilter;
    }
}

