/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.query;

import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.TimeUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(description="\u901a\u7528\u67e5\u8be2\u5668")
public class QueryFilter<T extends Model<T>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(QueryFilter.class);
    @ApiModelProperty(name="pageBean", notes="\u5206\u9875\u4fe1\u606f")
    private PageBean pageBean;
    @ApiModelProperty(name="sorter", notes="\u6392\u5e8f\u5b57\u6bb5")
    private List<FieldSort> sorter = new ArrayList<FieldSort>();
    @ApiModelProperty(name="params", notes="\u81ea\u5b9a\u4e49\u67e5\u8be2")
    private Map<String, Object> params = new LinkedHashMap<String, Object>();
    @ApiModelProperty(name="querys", notes="\u67e5\u8be2\u6761\u4ef6\u7ec4")
    private List<QueryField> querys = new ArrayList<QueryField>();
    @ApiModelProperty(name="groupRelation", notes="\u67e5\u8be2\u6761\u4ef6\u5206\u7ec4\u7684\u5173\u7cfb", example="AND")
    private FieldRelation groupRelation = FieldRelation.AND;

    private QueryFilter() {
    }

    public static <T extends Model<T>> QueryFilter<T> build() {
        return new QueryFilter<T>();
    }

    public QueryFilter<T> withDefaultPage() {
        this.pageBean = new PageBean();
        return this;
    }

    public QueryFilter<T> withPage(PageBean pageBean) {
        this.pageBean = pageBean;
        return this;
    }

    public QueryFilter<T> withSorter(FieldSort fieldSort) {
        this.sorter.add(fieldSort);
        return this;
    }

    public QueryFilter<T> withQuery(QueryField queryField) {
        this.querys.add(queryField);
        return this;
    }

    public QueryFilter<T> withParam(String key, Object value) {
        this.params.put(key, value);
        return this;
    }

    public PageBean getPageBean() {
        return this.pageBean;
    }

    public void setPageBean(PageBean pageBean) {
        this.pageBean = pageBean;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    @JsonIgnore
    public Map<String, Object> getParamsAndEmpty() {
        Map<String, Object> copyParams = this.params;
        this.params = new HashMap<String, Object>();
        return copyParams;
    }

    @JsonIgnore
    public Map<String, Object> getInitParams() {
        LinkedHashMap<String, Object> initParams = new LinkedHashMap<String, Object>();
        if (BeanUtils.isEmpty(this.querys)) {
            return initParams;
        }
        for (QueryField element : this.querys) {
            QueryField queryField = element;
            QueryOP operation = queryField.getOperation();
            if (QueryOP.IS_NULL.equals((Object)operation) || QueryOP.NOTNULL.equals((Object)operation) || QueryOP.IN.equals((Object)operation)) continue;
            String property = queryField.getProperty();
            if (property.indexOf(".") > -1) {
                property = property.substring(property.indexOf(".") + 1);
            }
            Object value = queryField.getValue();
            initParams.put(property, value);
        }
        initParams.putAll(this.params);
        return initParams;
    }

    public void addFilter(String property, Object value, QueryOP operation, FieldRelation relation) {
        QueryField queryField = new QueryField(property, value, operation, relation);
        this.querys.add(queryField);
    }

    public void addFilter(String property, Object value, QueryOP operation, FieldRelation relation, String group) {
        QueryField queryField = new QueryField(property, value, operation, relation, group);
        this.querys.add(queryField);
    }

    public void addFilter(String property, Object value, QueryOP operation) {
        QueryField queryField = new QueryField(property, value, operation, FieldRelation.AND);
        this.querys.add(queryField);
    }

    public void addParams(String property, Object value) {
        this.params.put(property, value);
    }

    public List<FieldSort> getSorter() {
        return this.sorter;
    }

    public void setSorter(List<FieldSort> sorter) {
        this.sorter = sorter;
    }

    public void setDefaultSort(String property, Direction direction) {
        if (BeanUtils.isEmpty(this.sorter)) {
            this.sorter.add(new FieldSort(property, direction));
        }
    }

    public List<QueryField> getQuerys() {
        return this.querys;
    }

    public void setQuerys(List<QueryField> querys) {
        long timeMillis = TimeUtil.getCurrentTimeMillis();
        if (BeanUtils.isNotEmpty(querys)) {
            for (QueryField queryField : querys) {
                if (!BeanUtils.isNotEmpty(queryField)) continue;
                if ("main".equals(queryField.getGroup())) {
                    queryField.setGroup("main_group_" + timeMillis);
                    continue;
                }
                if (!StringUtil.isEmpty(queryField.getGroup())) continue;
                queryField.setGroup("empty_group_" + timeMillis);
            }
        }
        this.querys = querys;
    }

    public FieldRelation getGroupRelation() {
        return this.groupRelation;
    }

    public void setGroupRelation(FieldRelation groupRelation) {
        this.groupRelation = groupRelation;
    }

    public Map<String, List<QueryField>> groupQueryField() {
        HashMap<String, List<QueryField>> map = new HashMap<String, List<QueryField>>();
        this.querys.forEach(q -> {
            String group = q.getGroup();
            ArrayList<QueryField> list = (ArrayList<QueryField>)map.get(group);
            if (list == null) {
                list = new ArrayList<QueryField>();
                map.put(group, list);
            }
            list.add((QueryField)q);
        });
        return map;
    }

    public List<String> getRootGroup(Map<String, String> groups) {
        ArrayList<String> rootGroups = new ArrayList<String>();
        for (String group : groups.keySet()) {
            if (!StringUtil.isEmpty(groups.get(group))) continue;
            rootGroups.add(group);
        }
        return rootGroups;
    }

    public Map<String, String> getGroupTree() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("main", null);
        this.querys.forEach(q -> {
            String parent;
            String group = q.getGroup();
            String parentGroup = q.getParentGroup();
            if (StringUtil.isNotEmpty(parentGroup) && (parent = (String)map.get(group)) != null && !parentGroup.equals(parent)) {
                logger.error("QueryFilter data conflict: mutiple parent of group " + group);
                logger.error("QueryFilter data :" + JsonUtil.toJsonString(this));
            }
            map.put(group, parentGroup);
        });
        return map;
    }

    public Map<Direction, List<FieldSort>> groupFieldSort() {
        HashMap<Direction, List<FieldSort>> map = new HashMap<Direction, List<FieldSort>>();
        this.sorter.forEach(q -> {
            Direction direct = q.getDirection();
            ArrayList<FieldSort> list = (ArrayList<FieldSort>)map.get((Object)direct);
            if (list == null) {
                list = new ArrayList<FieldSort>();
                map.put(direct, list);
            }
            list.add((FieldSort)q);
        });
        return map;
    }

    public void addQueryField(QueryField field) {
        this.querys.add(field);
    }
}

