/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.job;

import cn.hutool.core.util.RandomUtil;
import com.artfess.job.model.BaseJob;
import com.artfess.manage.base.dao.CmgtBasePositionDao;
import com.artfess.manage.base.model.CmgtBasePosition;
import com.artfess.manage.duty.dao.CmgtDutyJobDao;
import com.artfess.manage.duty.manager.CmgtDutyVehicleGpsinfoManager;
import com.artfess.manage.duty.manager.CmgtDutyWorkarrangeManager;
import com.artfess.manage.dwd.dao.DwdSjBusDepartedDao;
import com.artfess.manage.dwd.dao.DwdSjCqEventDao;
import com.artfess.manage.dwd.dao.DwdSjFestivalHolidayDao;
import com.artfess.manage.dwd.dao.DwdSjStationArrivedDao;
import com.artfess.manage.dwd.manager.DwdSjWeatherForcastMiManager;
import com.artfess.rocketmq.producer.RocketMQProducer;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.annotation.Resource;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CmgtLocationGeneratorJob
extends BaseJob {
    private static final Logger log = LoggerFactory.getLogger(CmgtLocationGeneratorJob.class);
    @Resource
    private CmgtDutyWorkarrangeManager cmgtDutyWorkarrangeManager;
    @Resource
    private CmgtDutyVehicleGpsinfoManager cmgtDutyVehicleGpsinfoManager;
    @Resource
    private CmgtDutyJobDao cmgtDutyJobDao;
    @Resource
    private RocketMQProducer rocketMQProducer;
    protected Logger logger = LoggerFactory.getLogger(CmgtLocationGeneratorJob.class);
    @Resource
    private DwdSjWeatherForcastMiManager dwdSjWeatherForcastMiManager;
    @Resource
    private CmgtBasePositionDao cmgtBasePositionDao;
    @Resource
    private DwdSjStationArrivedDao dwdSjStationArrivedDao;
    @Resource
    private DwdSjBusDepartedDao dwdSjBusDepartedDao;
    @Resource
    private DwdSjCqEventDao dwdSjCqEventDao;
    @Resource
    private DwdSjFestivalHolidayDao dwdSjFestivalHolidayDao;

    public void executeJob(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        log.info("===========jobDataMap============" + jobDataMap);
        this.cmgtDutyVehicleGpsinfoManager.createSumilatedGpsData();
        this.cmgtDutyWorkarrangeManager.createSumilatedTeamMemberLoationData();
        this.createAccidentPoint();
    }

    @Transactional
    private void createAccidentPoint() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"DTYPE_", (Object)"ACCIDENT");
        queryWrapper.between((Object)"RECEIVE_TIME_", (Object)(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 00:00:00"), (Object)(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 23:59:59"));
        List l = this.cmgtBasePositionDao.selectList((Wrapper)queryWrapper);
        if (l.size() < 3) {
            CmgtBasePosition position = new CmgtBasePosition();
            position.setDtype("ACCIDENT");
            position.setReceiveTime(LocalDateTime.now());
            position.setReceiveTime(LocalDateTime.now());
            position.setMemo("\u968f\u673a\u751f\u6210\u6a21\u62df\u6570\u636e");
            position.setLatitude(RandomUtil.randomBigDecimal((BigDecimal)BigDecimal.valueOf(106.537288), (BigDecimal)BigDecimal.valueOf(106.55633)) + "");
            position.setLongitude(RandomUtil.randomBigDecimal((BigDecimal)BigDecimal.valueOf(29.606626), (BigDecimal)BigDecimal.valueOf(29.615619)) + "");
            position.setName("\u4e8b\u6545\u6613\u53d1\u70b9(" + (l.size() + 1) + ")");
            this.cmgtBasePositionDao.insert((Object)position);
        }
    }
}

