package com.artfess.manage.safty.model;


import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * 安全工作目标信息(CmgtSaftyTarget)表实体类
 *
 * @author 黎沐华
 * @since 2023-05-04 13:31:32
 */
@Data
@TableName("CMGT_SAFTY_TARGET")
@ApiModel("安全工作目标信息(CmgtSaftyTarget)表实体类")
@FieldRepeat(fields = {"name"}, message = "名称不能重复，请重新输入", groups = {AddGroup.class, UpdateGroup.class})
public class CmgtSaftyTarget extends AutoFillModel<CmgtSaftyTarget> {

    @NotNull(message = "修改必须指定id", groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id", groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty("目标年度")
    @TableField("target_year_")
    private String targetYear;

    @ApiModelProperty("安全业务分类（参考字典 aqywlb）")
    @TableField("safty_class_")
    private String saftyClass;

    @ApiModelProperty("工作目标名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty("工作目标说明")
    @TableField("content_")
    private String content;

    @ApiModelProperty("具体工作描述")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty("相关依据描述")
    @TableField("according_")
    private String according;

    @ApiModelProperty("目标是否需要考核(默认：否)")
    @TableField("target_is_check_")
    private String targetIsCheck = "否";

    @ApiModelProperty("排序")
    @TableField("sn_")
    private Integer sn;

    /**
     * 删除标识，1已删除，0未删除
     */
    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    @TableField("is_dele_")
    private String isDele;

    /**
     * 版本号
     */
    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    /**
     * 数据时间戳
     */
    @ApiModelProperty(value = "数据时间戳")
    @TableField("last_time_")
    private LocalDateTime lastTime;

    @TableField(exist = false)
    @ApiModelProperty("考核项详情配置信息")
    private List<CmgtSaftyTargetCheck> detail = new ArrayList<>();

}

