package com.artfess.manage.material.manager.impl;

import com.artfess.base.enums.CodePrefix;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.manage.material.dao.CmgtMaterialOrderDao;
import com.artfess.manage.material.manager.CmgtMaterialOrderDetailManager;
import com.artfess.manage.material.manager.CmgtMaterialOrderManager;
import com.artfess.manage.material.manager.CmgtMaterialOrderSupplierManager;
import com.artfess.manage.material.model.CmgtMaterialOrder;
import com.artfess.manage.material.model.CmgtMaterialOrderDetail;
import com.artfess.manage.material.model.CmgtMaterialOrderSupplier;
import com.artfess.manage.material.model.CmgtMaterialSignWarehouse;
import com.artfess.manage.material.model.CmgtMaterialSignWarehouseDetail;
import com.artfess.redis.util.CodeCreatorUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * 采购订单表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-04-24
 */
@Service
public class CmgtMaterialOrderManagerImpl extends BaseManagerImpl<CmgtMaterialOrderDao, CmgtMaterialOrder> implements CmgtMaterialOrderManager {

    @Autowired
    private CmgtMaterialOrderDetailManager orderDetailManager;

    @Autowired
    private CmgtMaterialOrderSupplierManager supplierManager;

    @Resource
    private CodeCreatorUtil codeCreatorUtil;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean saveInfo(CmgtMaterialOrder t) {
        t.setStatus("1");
        String code = codeCreatorUtil.createCodeYYYYMMDD(CodePrefix.ORDER, 12);
        t.setCode(code);
        int insert = this.baseMapper.insert(t);
        if(insert > 0) {
            processDetailList(t);
            return true;
        }

        return false;
    }

    private void processDetailList(CmgtMaterialOrder t) {
        QueryWrapper<CmgtMaterialOrderDetail> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("order_id_", t.getId());
        this.orderDetailManager.remove(queryWrapper);
        if(CollectionUtils.isEmpty(t.getDetailList())) {
            return;
        }

        QueryWrapper<CmgtMaterialOrderSupplier> query = new QueryWrapper<>();
        query.eq("order_id_", t.getId());
        this.supplierManager.remove(query);
        t.getDetailList().forEach(detail -> {
            detail.setOrderId(t.getId());
        });
        orderDetailManager.saveOrUpdateBatch(t.getDetailList());
        if(!CollectionUtils.isEmpty(t.getSupplierList())) {
            t.getSupplierList().forEach(supplier -> {
                supplier.setOrderId(t.getId());
            });
            supplierManager.saveOrUpdateBatch(t.getSupplierList());
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(CmgtMaterialOrder t) {
        CmgtMaterialOrder order = baseMapper.selectById(t.getId());
        if (null == order) {
            throw new BaseException("申请单不存在");
        }
        t.setCode(order.getCode());
        t.setStatus(order.getStatus());
        int insert = this.baseMapper.updateById(t);
        if(insert > 0) {
            processDetailList(t);
            return true;
        }

        return false;
    }

    @Override
    public CmgtMaterialOrder findById(String id) {
        CmgtMaterialOrder cmgtMaterialOrder = this.baseMapper.selectById(id);
        if (null == cmgtMaterialOrder) {
            return new CmgtMaterialOrder();
        }
        QueryWrapper<CmgtMaterialOrderDetail> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("order_id_", id);
        List<CmgtMaterialOrderDetail> orderDetails = orderDetailManager.getBaseMapper().selectList(queryWrapper);
        cmgtMaterialOrder.setDetailList(orderDetails);

        QueryWrapper<CmgtMaterialOrderSupplier> query = new QueryWrapper<>();
        query.eq("order_id_", id);
        List<CmgtMaterialOrderSupplier> cmgtMaterialOrderSuppliers = supplierManager.getBaseMapper().selectList(query);

        cmgtMaterialOrder.setSupplierList(cmgtMaterialOrderSuppliers);
        return cmgtMaterialOrder;
    }
}
