package com.artfess.manage.safty.manager.dto;

import com.artfess.manage.base.ManageBaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;



/**
 * cmgt_safty_training_plan
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-03
 */
@Data
@ApiModel(value="CmgtSaftyTrainingPlanDto", description="安全培训计划DTO对象")
public class CmgtSaftyTrainingPlanDto extends ManageBaseModel<CmgtSaftyTrainingPlanDto> {


    /** 主键_ID */
    @ApiModelProperty(value = "主键_ID")
    private String id;




    /** 培训时间 */
    @ApiModelProperty(value = "培训时间")
    private LocalDateTime trainingDate;




    /** 培训项目 */
    @ApiModelProperty(value = "培训项目")
    private String trainingProjectId;

    private Object trainingProjectIdName;



    /** 培训地点 */
    @ApiModelProperty(value = "培训地点")
    private String location;




    /** 培训对象 */
    @ApiModelProperty(value = "培训对象")
    private String trainee;




    /** 培训讲师 */
    @ApiModelProperty(value = "培训讲师")
    private String teacher;




    /** 培训课程 */
    @ApiModelProperty(value = "培训课程")
    private String content;




    /** 排序 */
    @ApiModelProperty(value = "排序")
    private Integer sn;




    /** 备注 */
    @ApiModelProperty(value = "备注")
    private String memo;





    private String createByName;

}
