package com.artfess.manage.base.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.base.dao.CmgtBasePositionDao;
import com.artfess.manage.base.manager.CmgtBasePositionManager;
import com.artfess.manage.base.manager.dto.CmgtBasePositionDto;
import com.artfess.manage.base.manager.mapper.CmgtBasePositionDtoMapper;
import com.artfess.manage.base.model.CmgtBasePosition;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.model.User;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;



/**
 * 基础位置信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author fanxm
 * @since 2022-09-24
 */
@Service
public class CmgtBasePositionManagerImpl extends BaseManagerImpl<CmgtBasePositionDao, CmgtBasePosition> implements CmgtBasePositionManager {

    @Resource
    private UserDao userDao;

    @Resource
    private CmgtBasePositionDao cmgtBasePositionDao;

    @Resource
    private CmgtBasePositionDtoMapper cmgtBasePositionDtoMapper ;

    @Resource
    private ManageCommonService manageCommonService;


    @Override
    public PageList<CmgtBasePositionDto> pageQuery(QueryFilter<CmgtBasePosition> queryFilter) {
        PageList<CmgtBasePosition> result = query(queryFilter);
        PageList<CmgtBasePositionDto> r = new PageList<CmgtBasePositionDto>(
                result.getRows().stream().map(e -> {
                            CmgtBasePositionDto t = cmgtBasePositionDtoMapper.toDto(e);


                            if(e.getCreateBy()!=null){
                               User user = userDao.selectById(e.getCreateBy());
                               if(user!=null){
                                   t.setCreateByName(user.getFullname());
                               }
                            }

                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(CmgtBasePosition t) {
        int i = this.baseMapper.insert(t);
        if(i>0){
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(CmgtBasePosition t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(CmgtBasePosition t) {
        this.baseMapper.deleteById(t.getId());
    }


    public String create(CmgtBasePositionDto dto) {
        CmgtBasePosition t = cmgtBasePositionDtoMapper.toEntity(dto);
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }


    public String update(CmgtBasePositionDto dto) {
        CmgtBasePosition t = cmgtBasePositionDtoMapper.toEntity(dto);
        this.baseMapper.updateById(t);


        return t.getId();
    }

    public boolean delete(List<String> ids) {
        for (String id : ids) {

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }




}
