/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.utils;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.artfess.base.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class GeoUtils {
    public static boolean pointInPolygon(String p, String polyStr) {
        if (StringUtil.isEmpty((String)polyStr)) {
            return false;
        }
        ArrayList<Point> polys = new ArrayList<Point>();
        JSONUtil.parseArray((String)polyStr).forEach(e -> {
            JSONArray pt = (JSONArray)e;
            polys.add(new Point(Float.valueOf(pt.get(0) + "").floatValue(), Float.valueOf(pt.get(1) + "").floatValue()));
        });
        String[] point = p.split(",");
        return GeoUtils.ray(new Point(Float.valueOf(point[0] + "").floatValue(), Float.valueOf(point[1] + "").floatValue()), polys);
    }

    public static boolean ray(Point p, List<Point> poly) {
        float nx = p.x;
        float ny = p.y;
        int cnt = 0;
        int len = poly.size();
        int i = 0;
        int j = len - 1;
        while (i < len) {
            float bx = poly.get((int)i).x;
            float by = poly.get((int)i).y;
            float ux = poly.get((int)j).x;
            float uy = poly.get((int)j).y;
            if (nx == bx && ny == by || nx == ux && nx == uy) {
                return true;
            }
            if (by < ny && uy >= ny || by >= ny && uy < ny) {
                float x = bx + (ny - by) * (ux - bx) / (uy - by);
                if (x == nx) {
                    return true;
                }
                if (x > nx) {
                    ++cnt;
                }
            }
            j = i++;
        }
        return cnt % 2 == 1;
    }

    static class Point {
        float x;
        float y;

        Point() {
        }

        Point(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

