package com.artfess.device.monitor.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.DateUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.device.base.dto.StatisticsDto;
import com.artfess.device.base.utils.BizUtils;
import com.artfess.device.monitor.dao.DeviceDataWaterDao;
import com.artfess.device.monitor.manager.DeviceDataWaterManager;
import com.artfess.device.monitor.model.DeviceDataWater;
import com.artfess.device.monitor.vo.WaterStatisticVo;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Comparator;
import java.util.List;
import java.util.Map;

/**
 * 实时监控-水位监控（DEVICE_DATA_WATER） 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2022-07-26
 */
@Service
public class DeviceDataWaterManagerImpl extends BaseManagerImpl<DeviceDataWaterDao, DeviceDataWater> implements DeviceDataWaterManager {

    @Autowired
    private SysDictionaryManager sdm;
    
    @Override
    public CommonResult findByDeviceId(String productType,QueryFilter<DeviceDataWater>queryFilter) {
        Map<String, Object> data = Maps.newHashMap();
        data.put("productType", productType);

        PageBean pageBean = queryFilter.getPageBean();
        IPage<DeviceDataWater> result = baseMapper.query(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));

        data.put("data", new PageList<DeviceDataWater>(result));
        return CommonResult.success(data, "查询成功");
    }

    @Override
    @Transactional(readOnly=true)
    public PageList<DeviceDataWater> query(QueryFilter<DeviceDataWater> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Class<DeviceDataWater> currentModelClass = currentModelClass();
        IPage<DeviceDataWater> result = baseMapper.query(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass));
        return new PageList<DeviceDataWater>(result);
    }

    @Override
    public WaterStatisticVo statistic(StatisticsDto dto) {
        // 字典
        List<DictModel> rqlx = sdm.queryDictListItemsByCode("rqlx");
        // 默认格式
        dto.setDateType(BizUtils.getDicValueByCode(rqlx, dto.getDateType()));
        if (StringUtil.isEmpty(dto.getDateType())) {
            dto.setDateType("%Y-%m-%d");
        }
        if (StringUtil.isEmpty(dto.getTime())) {
            dto.setTime(DateUtils.formatDate());
        }
        return baseMapper.statistic(dto).stream().max(Comparator.comparing(WaterStatisticVo::getWaterLevel)).orElse(new WaterStatisticVo());
    }
}
