package com.artfess.device.base.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 对备品库信息进行管理
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-12
 */
@Data
@FieldRepeat(fields = {"warehouseCode","warehouseName"},message = "备件库名称或代码不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
@ApiModel(value="DeviceBaseWarehouse对象", description="对备品库信息进行管理")
public class DeviceBaseWarehouse extends AutoFillModel<DeviceBaseWarehouse> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定备件库id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请填写备件库编码",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "备件库编码")
    @TableField("WAREHOUSE_CODE_")
    private String warehouseCode;

    @NotBlank(message = "请填写备件库名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "备件库名称")
    @TableField("WAREHOUSE_NAME_")
    private String warehouseName;

    @ApiModelProperty(value = "备件库地址")
    @TableField("WAREHOUSE_ADDRESS_")
    private String warehouseAddress;

    @ApiModelProperty(value = "备注")
    @TableField("MEMO_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "经度（单位：度）")
    @TableField("longitude_")
    private String longitude;

    @ApiModelProperty(value = "纬度（单位：度）")
    @TableField("latitude_")
    private String latitude;

    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Integer version;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "扩展信息填充内容")
    @TableField(exist = false)
    private List<DeviceBaseParamsValue> paramsValueList;

}
