package com.artfess.device.base.dao;

import com.artfess.device.base.model.DeviceVideoPointExtend;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

/**
 * 视频点位扩展信息表与视频点位信息一一对应（DEVICE_VIDEO_POINT_EXTEND） Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-08-19
 */
public interface DeviceVideoPointExtendDao extends BaseMapper<DeviceVideoPointExtend> {

    /**
     * @Description: 根据摄像头编码查询扩展信息
     * @param videoCode 摄像头编码
     * @Return: com.artfess.bzzgj.device.model.DeviceVideoPointExtend
     * @Author: chens
     * @Date: 2022/9/14 14:05
     */
    DeviceVideoPointExtend findVideoExtendByCode(@Param("videoCode") String videoCode);
}
