package com.artfess.device.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.device.base.manager.DeviceBaseParamsConfManager;
import com.artfess.device.base.model.DeviceBaseParamsConf;
import com.artfess.device.base.model.DeviceBaseParamsValue;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 基础扩展信息表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-19
 */
@Slf4j
@RestController
@Api(tags = "设施设备-基础扩展信息")
@RequestMapping("/device/base/paramsConf")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class DeviceBaseParamsConfController extends BaseController<DeviceBaseParamsConfManager, DeviceBaseParamsConf> {

    @PostMapping(value="/findAll", produces={"application/json; charset=utf-8" })
    @ApiOperation("根据配置类型获取扩展字段列表（不分页）")
    public List<DeviceBaseParamsConf> findAll(@ApiParam(name="model", value="查询条件") @RequestBody DeviceBaseParamsConf conf) {
        return baseService.findAll(conf);
    }

    @PostMapping(value="/getConfValue", produces={"application/json; charset=utf-8" })
    @ApiOperation("根据配置类型和基础信息id获取扩展信息内容")
    public List<DeviceBaseParamsValue> getConfValue(@ApiParam(name="model", value="查询条件") @RequestBody DeviceBaseParamsValue value) {
        return baseService.getConfValue(value);
    }

}
