package com.artfess.device.base.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 视频目录基础信息表（DEVICE_VIDEO_BASE）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-08-19
 */
@Data
@ApiModel(value="DeviceVideoBase对象", description="视频目录基础信息表（DEVICE_VIDEO_BASE）")
public class DeviceVideoBase extends AutoFillModel<DeviceVideoBase> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "所属平台(HK：海康平台，ZG：紫光平台)")
    @TableField("platform_")
    private String platform;

    @ApiModelProperty(value = "目录编码（或视频平台的业务目录编码）")
    @TableField("code_")
    private String code;

    @ApiModelProperty(value = "目录名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "类型（1：基础目录  2：业务目录）")
    @TableField("type_")
    private String type;

    @ApiModelProperty(value = "排序号")
    @TableField("sn_")
    private Integer sn;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;


}
