package com.artfess.device.base.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.base.dao.DeviceBaseUserDao;
import com.artfess.device.base.manager.DeviceBaseUserManager;
import com.artfess.device.base.model.DeviceBaseUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 对单位人员信息进行管理 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-12
 */
@Service
public class DeviceBaseUserManagerImpl extends BaseManagerImpl<DeviceBaseUserDao, DeviceBaseUser> implements DeviceBaseUserManager {

    @Override
    public List<DeviceBaseUser> findByCompanyIds(List<String> companyIds) {
        QueryWrapper<DeviceBaseUser> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("COMPANY_ID_", companyIds);
        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        return baseMapper.selectList(queryWrapper);
    }

    @Override
    public PageList<DeviceBaseUser> findByPage(QueryFilter<DeviceBaseUser> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<DeviceBaseUser> result = baseMapper.queryPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<DeviceBaseUser>(result);
    }
}
