package com.artfess.device.base.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.device.base.dto.StatisticsDto;
import com.artfess.device.base.model.DeviceWarnInfo;
import com.artfess.device.base.vo.StatisticsVo;

import java.util.List;

/**
 * 设备告警信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
public interface DeviceWarnInfoManager extends BaseManager<DeviceWarnInfo> {

    Integer findByDeviceType(String productType);

    /**
     * 获取设备最新的报警数据
     * @param deviceCode 设备编码
     * @param warnType 报警类型（1：设备故障报警，2：设备监测数据报警）
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2022/8/1 17:53
     */
    DeviceWarnInfo getNewWarnInfo(String deviceCode, String warnType);

    /**
     * 发送报警数据到事件中心
     * @param warnInfo  报警数据
     * @Return: void
     * @Author: chens
     * @Date: 2022/9/7 16:11
     */
    void sendWarnInfoToEventCenter(DeviceWarnInfo warnInfo);

    /**
     * 告警统计
     * @param dto 参数
     * @return 结果
     */
    List<StatisticsVo> statisticsWarn(StatisticsDto dto);

    /**
     * 告警统计下钻
     * @param dto 参数
     * @return 结果
     */
    List<StatisticsVo> statisticsWarnSub(StatisticsDto dto);

    /**
     * 各月份设备告警数
     * @return 结果
     */
    List<StatisticsVo> warnCountMonthly();

    /**
     * 截止至当前时间的设备告警数量统计
     * @return 结果
     */
    List<StatisticsVo> warnCountCurrently();
}
