package com.artfess.device.base.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.device.base.dao.DeviceBaseContractDao;
import com.artfess.device.base.dao.DeviceRelationContractDao;
import com.artfess.device.base.manager.DeviceRelationContractManager;
import com.artfess.device.base.model.DeviceBaseContract;
import com.artfess.device.base.model.DeviceInfo;
import com.artfess.device.base.model.DeviceRelationContract;
import com.artfess.device.base.vo.ContractDeviceVo;
import com.artfess.device.base.vo.ContractVo;
import com.artfess.device.base.vo.DeviceVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 设备合同关联表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Service
public class DeviceRelationContractManagerImpl extends BaseManagerImpl<DeviceRelationContractDao, DeviceRelationContract> implements DeviceRelationContractManager {

    @Resource
    private DeviceBaseContractDao contractDao;

    @Override
    public PageList<DeviceVo> findByPage(QueryFilter<DeviceInfo> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<DeviceVo> result = baseMapper.queryPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<DeviceVo>(result);
    }

    @Override
    public void bindDevice(ContractVo t) {
        Assert.hasText(t.getContractId(), "请选择要关联的合同");
        QueryWrapper<DeviceRelationContract> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id_", t.getContractId());
        this.baseMapper.delete(queryWrapper);

        t.getDeviceList().forEach(deviceInfo -> {
            DeviceRelationContract deviceRelationContract = new DeviceRelationContract();
            deviceRelationContract.setDeviceId(deviceInfo.getId());
            deviceRelationContract.setContractId(t.getContractId());
            baseMapper.insert(deviceRelationContract);
        });
    }

    @Override
    public PageList<ContractDeviceVo> getDeviceList(QueryFilter queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Page page = new Page(pageBean.getPage(), pageBean.getPageSize());
        Map<String, Object> params = queryFilter.getParams();
        if(params.get("contractId")==null || StringUtil.isEmpty(params.get("contractId").toString())){
            throw new ApplicationException("合同ID【contractId】不能为空！");
        }
        IPage<ContractDeviceVo> result = baseMapper.getDeviceList(page,params);
        return new PageList<>(result);

    }

    @Override
    public void bindContract(DeviceVo t) {
        Assert.hasText(t.getDeviceId(), "请选择要关联的设备");
        QueryWrapper<DeviceRelationContract> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("device_id_", t.getDeviceId());
        this.baseMapper.delete(queryWrapper);

        t.getContracts().forEach(contract -> {
            DeviceRelationContract deviceRelationContract = new DeviceRelationContract();
            deviceRelationContract.setDeviceId(t.getDeviceId());
            deviceRelationContract.setContractId(contract.getId());
            baseMapper.insert(deviceRelationContract);
        });
    }

    @Override
    public DeviceVo getContractList(DeviceVo t) {

        List<DeviceBaseContract> list = this.contractDao.getContractList(t.getDeviceId());
        t.setContracts(list);
        return t;
    }

    @Override
    public PageList<DeviceBaseContract> findByContractPage(QueryFilter<DeviceBaseContract> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<DeviceBaseContract> result = baseMapper.findByContractPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<DeviceBaseContract>(result);
    }
}
