package com.artfess.device.monitor.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.base.vo.ActGroupVo;
import com.artfess.device.monitor.model.DeviceDataBarricade;

import java.util.List;

/**
 * 实时监控-路障操作数据（DEVICE_DATA_BARRICADE） 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-08-01
 */
public interface DeviceDataBarricadeManager extends BaseManager<DeviceDataBarricade> {
    /**
     * 批量修改升降柱
     * @param entity
     * @return
     */
    String batchAct(List<ActGroupVo> entity);

    String lockAct(List<ActGroupVo> vo);

    /**
     * 根据设备id获取实时数据
     * @param id
     * @return
     */
    CommonResult findByDeviceId(String productType, QueryFilter<DeviceDataBarricade> queryFilter);
}
