package com.artfess.device.monitor.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.device.monitor.manager.DeviceDataHazardManager;
import com.artfess.device.monitor.model.DeviceDataHazard;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 实时监控-危险源监控（DEVICE_DATA_HAZARD） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-08-01
 */
@Slf4j
@RestController
@Api(tags = "设施数据-危险源监控")
@RequestMapping("/data/hazard/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class DeviceDataHazardController extends BaseController<DeviceDataHazardManager, DeviceDataHazard> {

}
