package com.artfess.device.base.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;



/**
 * 合同关联的设备信息vo
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2022-09-19
 */
@Data
@ApiModel(value="合同关联的设备信息vo")
public class ContractDeviceVo {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "设备主键_ID")
    private String id;

    @ApiModelProperty(value = "合同ID")
    private String contractId;

    @ApiModelProperty(value = "设备标识")
    private String code;

    @ApiModelProperty(value = "设备名称")
    private String name;

    @ApiModelProperty(value = "设备状态【字典】（-1：报废，1：正常、2：故障、3、报警、9：其他）")
    private String status;

    @ApiModelProperty(value = "设备IP")
    private String ip;

    @ApiModelProperty(value = "经度")
    private String lgtd;

    @ApiModelProperty(value = "纬度")
    private String lttd;

    @ApiModelProperty(value = "安装详细地址")
    private String address;

    @ApiModelProperty(value = "产品分类编码")
    private String proTypeCode;

    @ApiModelProperty(value = "产品分类")
    private String proTypeName;



}
