package com.artfess.device.base.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 设备关联分组信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Data
@ApiModel(value="DeviceRelationGroup对象", description="设备关联分组信息")
public class DeviceRelationGroup extends BaseModel<DeviceRelationGroup> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "分组ID")
    @TableField("group_id_")
    private String groupId;

    @ApiModelProperty(value = "设备ID")
    @TableField("device_id_")
    private String deviceId;

}
