package com.artfess.device.base.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;

/**
 * 产品告警配置详情
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Data
@FieldRepeat(fields = {"warnKey"},message = "告警参数名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
@ApiModel(value="DeviceProductWarnConfDetails对象", description="产品告警配置详情")
public class DeviceProductWarnConfDetails extends BaseModel<DeviceProductWarnConfDetails> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定告警数据id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "告警配置ID")
    @TableField("product_warn_conf_id_")
    private String productWarnConfId;

    @NotBlank(message = "请选择告警数据类型",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "告警数据类型（1：物模型属性，2：物模型事件）")
    @TableField("warn_type_")
    private String warnType;

    @NotBlank(message = "请输入告警参数名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "告警参数名称")
    @TableField("warn_key_")
    private String warnKey;

    @NotBlank(message = "请选择告警条件",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "告警条件（=，!=，<，>，<=，>=），字典")
    @TableField("warn_condition_")
    private String warnCondition;

    @NotBlank(message = "请输入告警值",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "告警值")
    @TableField("warn_value_")
    private String warnValue;

    @ApiModelProperty(value = "物模型属性（事件）标识")
    @TableField("METADATA_CODE_")
    private String metadataCode;

    @ApiModelProperty(value = "告警间关联类型(and，or)")
    @TableField("WARN_RELATION_")
    private String warnRelation;

}
